jQuery( document ).ready( function ( $ ) {
    // Settings page tabs
    var $tabs = $( '.ucs-nav-tabs a.nav-tab' );
    var $content = $( '.ucs-tab-content' );

    $tabs.on( 'click', function ( e ) {
        e.preventDefault();
        
        var $this = $( this );
        var targetId = $this.attr( 'href' );

        // Update tabs
        $tabs.removeClass( 'nav-tab-active' );
        $this.addClass( 'nav-tab-active' );

        // Update content
        $content.removeClass( 'active' ).hide();
        $( targetId ).addClass( 'active' ).show();
    } );

    // Trigger click on page load to show the correct tab (e.g., if there's a hash)
    var hash = window.location.hash;
    if ( hash ) {
        var $targetTab = $tabs.filter( '[href="' + hash + '"]' );
        if ( $targetTab.length ) {
            $targetTab.trigger( 'click' );
        } else {
            // Default to first tab if hash is invalid
            $tabs.first().trigger( 'click' );
        }
    } else {
        // Default to first tab
        $tabs.first().trigger( 'click' );
    }
} );