(function (blocks, element, components, blockEditor, apiFetch, compose) {
  var el = element.createElement;
  var registerBlockType = blocks.registerBlockType;
  var InspectorControls = blockEditor.InspectorControls;
  var useBlockProps = blockEditor.useBlockProps;
  var (PanelBody, TextControl, Spinner, SelectControl) = components;
  var (useState, useEffect) = element;
  var useDebounce = compose.useDebounce;

  var blockName = 'ucs-streamer/channel-player';

  registerBlockType(blockName, {
    title: 'Channel Player',
    icon: 'video-alt3',
    category: 'media',
    attributes: {
      channelId: {
        type: 'number',
        default: 0,
      },
      channelName: {
        type: 'string',
        default: '',
      },
    },

    edit: function (props) {
      var attributes = props.attributes;
      var setAttributes = props.setAttributes;
      var (channelId, channelName) = attributes;

      var [searchTerm, setSearchTerm] = useState('');
      var [searchResults, setSearchResults] = useState([]);
      var [isLoading, setIsLoading] = useState(false);
      var debouncedSetSearchTerm = useDebounce(setSearchTerm, 300);

      var blockProps = useBlockProps({
        style: {
          padding: '20px',
          backgroundColor: '#f0f0f0',
          border: '1px dashed #ccc',
          borderRadius: '8px',
        },
      });

      // Fetch results when searchTerm changes
      useEffect(
        function () {
          if (!searchTerm) {
            setSearchResults([]);
            return;
          }
          setIsLoading(true);
          apiFetch({ path: '/ucs/v1/search?q=' + searchTerm })
            .then(function (results) {
              setSearchResults(results);
              setIsLoading(false);
            })
            .catch(function () {
              setSearchResults([]);
              setIsLoading(false);
            });
        },
        [searchTerm]
      );

      // Handler for when a channel is selected
      function onSelectChannel(selectedId) {
        var selectedChannel = searchResults.find(function (c) {
          return c.id == selectedId;
        });
        if (selectedChannel) {
          setAttributes({
            channelId: parseInt(selectedId, 10),
            channelName: selectedChannel.title,
          });
        } else {
            setAttributes({
                channelId: 0,
                channelName: '',
            });
        }
      }

      // Options for the SelectControl
      var selectOptions = [
        { label: 'Select a channel', value: 0 },
      ];
      if (searchResults.length > 0) {
        searchResults.forEach(function (channel) {
          selectOptions.push({
            label: channel.title,
            value: channel.id,
          });
        });
      }

      return el(
        element.Fragment,
        null,
        // Inspector (Sidebar) Controls
        el(
          InspectorControls,
          null,
          el(
            PanelBody,
            { title: 'Channel Selection' },
            el(TextControl, {
              label: 'Search for a Channel',
              onChange: debouncedSetSearchTerm,
              placeholder: 'Type to search...',
            }),
            isLoading && el(Spinner, null),
            !isLoading &&
              searchTerm &&
              el(SelectControl, {
                label: 'Select a Channel',
                value: channelId,
                options: selectOptions,
                onChange: onSelectChannel,
              }),
            !isLoading &&
              searchTerm &&
              !searchResults.length &&
              el('p', null, 'No results found.')
          )
        ),
        // Block Preview
        el(
          'div',
          blockProps,
          el('strong', null, 'UCS Channel Player'),
          channelId
            ? el(
                'p',
                null,
                'Selected Channel: ',
                el('strong', null, channelName),
                ' (ID: ' + channelId + ')',
                el('br', null),
                el('small', null, 'Player will render on the frontend.')
              )
            : el(
                'p',
                null,
                'Please search for and select a channel from the settings panel on the right.'
              )
        )
      );
    },

    save: function () {
      // Dynamic block, save returns null
      return null;
    },
  });
})(
  window.wp.blocks,
  window.wp.element,
  window.wp.components,
  window.wp.blockEditor,
  window.wp.apiFetch,
  window.wp.compose
);