<?php
class UCS_Init {

    public static function run() {
        // Core Init
        add_action( 'init', array( __CLASS__, 'register_content_types' ) );
        add_action( 'admin_menu', array( 'UCS_Settings', 'add_admin_menu' ) );
        add_action( 'admin_init', array( 'UCS_Settings', 'register_settings' ) );
        
        // Scripts
        add_action( 'wp_enqueue_scripts', array( __CLASS__, 'enqueue_frontend' ) );
        add_action( 'admin_enqueue_scripts', array( __CLASS__, 'enqueue_admin' ) );
        
        // AJAX
        add_action( 'wp_ajax_ucs_run_m3u_import', array( 'UCS_Importer', 'handle_m3u_import_ajax' ) );
        add_action( 'wp_ajax_ucs_load_channels', array( 'UCS_Player', 'handle_load_channels_ajax' ) );
        add_action( 'wp_ajax_nopriv_ucs_load_channels', array( 'UCS_Player', 'handle_load_channels_ajax' ) );
        
        // Admin Post (CSV/License)
        add_action( 'admin_post_ucs_handle_csv_upload', array( 'UCS_Importer', 'handle_csv_upload' ) );
        add_action( 'admin_post_ucs_activate_license', array( 'UCS_License', 'handle_activation_request' ) ); 

        // Shortcodes
        add_shortcode( 'ucs_channel_directory', array( 'UCS_Player', 'render_directory' ) );
        add_shortcode( 'ucs_player', array( 'UCS_Player', 'render_player' ) );
        
        // Metaboxes
        add_action( 'add_meta_boxes', array( __CLASS__, 'add_channel_metabox' ) );
        add_action( 'save_post_ucs_channel', array( __CLASS__, 'save_channel_metabox_data' ) );
    }

    public static function register_content_types() {
        // 1. Register Categories Taxonomy
        register_taxonomy( 'ucs_category', 'ucs_channel', array(
            'hierarchical' => true,
            'public' => true,
            'show_ui' => true, // RESTORES MENU
            'show_admin_column' => true,
            'show_in_rest' => true,
            'labels' => array( 'name' => 'Channel Categories', 'singular_name' => 'Category' )
        ) );
        
        // 2. Register Country Taxonomy
        register_taxonomy( 'ucs_country', 'ucs_channel', array(
            'hierarchical' => false,
            'public' => true,
            'show_ui' => true, // RESTORES MENU
            'show_admin_column' => true,
            'show_in_rest' => true,
            'labels' => array( 'name' => 'Countries', 'singular_name' => 'Country' )
        ) );

        // 3. Register Channel CPT
        register_post_type( 'ucs_channel', array(
            'labels' => array( 
                'name' => 'Stream Channels', 
                'singular_name' => 'Channel',
                'add_new' => 'Add New Channel',
                'add_new_item' => 'Add New Stream Channel'
            ),
            'public' => true,
            'has_archive' => true,
            'show_ui' => true, // RESTORES UI
            'show_in_menu' => true, // RESTORES MENU
            'menu_position' => 5,
            'rewrite' => array( 'slug' => 'stream' ),
            'supports' => array( 'title', 'thumbnail', 'editor' ), // Editor allows description
            'menu_icon' => 'dashicons-video-alt',
            'show_in_rest' => true,
        ) );
    }

    // ... (Enqueue, Admin, Metabox functions remain standard) ...

    public static function enqueue_frontend() {
        wp_enqueue_style( 'videojs', 'https://cdn.jsdelivr.net/npm/video.js@8.10.0/dist/video-js.min.css' );
        wp_enqueue_style( 'ucs-css', UCS_PLUGIN_URL . 'assets/css/ucs-player.css', array(), UCS_VERSION );
        
        wp_enqueue_script( 'videojs', 'https://cdn.jsdelivr.net/npm/video.js@8.10.0/dist/video.min.js', array(), '8.10.0', true );
        wp_enqueue_script( 'ucs-js', UCS_PLUGIN_URL . 'assets/js/ucs-player.js', array( 'jquery', 'videojs' ), UCS_VERSION, true );
        
        $opts = get_option('ucs_settings');
        wp_localize_script( 'ucs-js', 'ucs_data', array(
            'ajax_url' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('ucs_load_channels_nonce'),
            'is_logged_in' => is_user_logged_in(),
            'paywall_limit_sec' => $opts['paywall_limit_sec'] ?? 60
        ));
    }

    public static function enqueue_admin($hook) {
        if( strpos($hook, 'ucs-settings') === false ) return;
        wp_enqueue_script( 'ucs-admin', UCS_PLUGIN_URL . 'assets/js/ucs-admin.js', array('jquery'), UCS_VERSION, true );
        wp_localize_script( 'ucs-admin', 'ucs_admin_data', array( 
            'ajax_url' => admin_url('admin-ajax.php'), 
            'import_m3u_nonce' => wp_create_nonce('ucs_import_m3u_nonce') 
        ));
        wp_enqueue_style( 'ucs-admin-css', UCS_PLUGIN_URL . 'assets/css/ucs-admin.css' );
    }

    public static function add_channel_metabox() { 
        add_meta_box('ucs_details', 'Stream Details', array(__CLASS__, 'render_metabox'), 'ucs_channel', 'normal', 'high'); 
    }
    
    public static function render_metabox($post) {
        $url = get_post_meta($post->ID, 'ucs_m3u8_link', true);
        $logo = get_post_meta($post->ID, 'ucs_logo_url', true);
        echo '<p>Stream URL (M3U8): <input type="url" name="ucs_m3u8_link" value="'.esc_attr($url).'" style="width:100%"></p>';
        echo '<p>Logo URL: <input type="url" name="ucs_logo_url" value="'.esc_attr($logo).'" style="width:100%"></p>';
    }
    
    public static function save_channel_metabox_data($post_id) {
        if(isset($_POST['ucs_m3u8_link'])) update_post_meta($post_id, 'ucs_m3u8_link', esc_url_raw($_POST['ucs_m3u8_link']));
        if(isset($_POST['ucs_logo_url'])) update_post_meta($post_id, 'ucs_logo_url', esc_url_raw($_POST['ucs_logo_url']));
    }
}