<?php
/**
 * The template for displaying a single Channel.
 *
 * @package UCS_Streamer
 */

get_header(); ?>

	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">

			<?php
			// Start the Loop.
			while ( have_posts() ) :
				the_post();
				?>
				<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
					<header class="entry-header">
						<?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
					</header>

					<div class="entry-content">
						
						<?php
						// Display the player
						if ( class_exists( 'UCS_Frontend' ) ) {
							echo UCS_Frontend::get_player_html( get_the_ID() );
						}
						?>

						<?php
						// Display post content (description)
						the_content();

						// Display categories and countries
						$categories = get_the_term_list( get_the_ID(), 'channel_category', __( 'Categories: ', 'ucs-streamer' ), ', ', '' );
						$countries = get_the_term_list( get_the_ID(), 'channel_country', __( 'Country: ', 'ucs-streamer' ), ', ', '' );
						
						if ( $categories || $countries ) {
							echo '<footer class="entry-footer">';
							if ( $categories ) {
								echo '<span class="categories-links">' . $categories . '</span>';
							}
							if ( $countries ) {
								echo '<span class="countries-links">' . $countries . '</span>';
							}
							echo '</footer>';
						}
						?>
					</div>

				</article>

			<?php
			endwhile; // End of the loop.
			?>

		</main>
	</div>

<?php get_sidebar(); ?>
<?php get_footer(); ?>