<?php
/**
 * Plugin Name: Ultimate Content Streamer (UCS)
 * Plugin URI: https://www.ultimatemultimediaconsult.com
 * Description: Enables premium, monetized HLS (m3u8) video streaming on WordPress with Video.js, WooCommerce, and License verification.
 * Version: 1.0.3
 * Author: Your Streaming Guru
 * Text Domain: ucs
 * License: GPL-2.0+
 */

if ( ! defined( 'ABSPATH' ) ) exit;

// Define constants
define( 'UCS_VERSION', '1.0.3' );
define( 'UCS_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'UCS_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'UCS_TEXT_DOMAIN', 'ucs' );

// --- LICENSE MANAGER CONFIGURATION ---
// No API Keys/Secrets here for security. Verification happens via Endpoint + License Key.
define( 'UCS_PREMIUM_PRODUCT_ID', '15624' ); 
define( 'UCS_UWLM_API_ENDPOINT', 'https://www.ultimatemultimediaconsult.com/wp-json/uwlm/v1/check' );

/**
 * Autoloader and Initialization
 */
require_once UCS_PLUGIN_DIR . 'includes/class-ucs-utils.php';
require_once UCS_PLUGIN_DIR . 'includes/class-ucs-license.php'; // License Handler
require_once UCS_PLUGIN_DIR . 'includes/class-ucs-init.php';
require_once UCS_PLUGIN_DIR . 'includes/class-ucs-settings.php';
require_once UCS_PLUGIN_DIR . 'includes/class-ucs-importer.php';
require_once UCS_PLUGIN_DIR . 'includes/class-ucs-player.php';

function ucs_run_plugin() {
    UCS_Init::run();
}
ucs_run_plugin();