<?php
/**
 * Fired when the plugin is uninstalled.
 *
 * @package UCS_Streamer
 */

// If uninstall not called from WordPress, exit.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

// Clear cron
wp_clear_scheduled_hook( 'ucs_daily_license_check' );

// Delete Options
delete_option( 'ucs_options' );
delete_option( '_ucs_channels_preloaded' );
delete_option( 'ucs_license_status' );
delete_option( 'ucs_license_expires' );

// Cautious: We won't delete all 'channel' CPTs or taxonomies
// by default, as the user might not want to lose all their data.
// To delete data, uncomment the lines below.

/*
global $wpdb;

// Delete posts
$wpdb->query( "DELETE FROM {$wpdb->posts} WHERE post_type = 'channel'" );
$wpdb->query( "DELETE FROM {$wpdb->posts} WHERE post_type = 'ucs_ad_creative'" );
$wpdb->query( "DELETE meta FROM {$wpdb->postmeta} meta LEFT JOIN {$wpdb->posts} posts ON posts.ID = meta.post_id WHERE posts.ID IS NULL" );

// Delete terms
$terms = get_terms( array( 'channel_category', 'channel_country' ), array( 'fields' => 'ids', 'hide_empty' => false ) );
if ( $terms ) {
	$term_ids = implode( ',', $terms );
	$wpdb->query( "DELETE FROM {$wpdb->terms} WHERE term_id IN ($term_ids)" );
	$wpdb->query( "DELETE FROM {$wpdb->term_taxonomy} WHERE term_id IN ($term_ids)" );
	$wpdb->query( "DELETE FROM {$wpdb->term_relationships} WHERE term_taxonomy_id NOT IN (SELECT term_taxonomy_id FROM {$wpdb->term_taxonomy})" );
}
*/