jQuery(document).ready(function($) {
    
    // ============================================================
    // 0. ROBUST TAB NAVIGATION
    // ============================================================
    $(document).on('click', '.ucmr-nav-tab', function(e) {
        if($(this).hasClass('ucmr-sub-tab')) return; 
        e.preventDefault();
        
        var target = $(this).attr('href');
        
        $('.ucmr-nav-tab').not('.ucmr-sub-tab').removeClass('ucmr-nav-tab-active');
        $(this).addClass('ucmr-nav-tab-active');
        
        $('.ucmr-tab-content').removeClass('ucmr-tab-content-active').hide();
        $(target).addClass('ucmr-tab-content-active').show();
        
        if(history.pushState) { history.pushState(null, null, target); }
    });

    // Handle Sub-Tabs (Ad Placements)
    $(document).on('click', '.ucmr-sub-tab', function(e) {
        e.preventDefault();
        var target = $(this).attr('href');
        $('.ucmr-sub-tab').removeClass('ucmr-nav-tab-active');
        $(this).addClass('ucmr-nav-tab-active');
        $('.ucmr-sub-content').hide();
        $(target).show();
    });

    // Check Hash on Load
    var hash = window.location.hash;
    if (hash && $(hash).length) { 
        $('.ucmr-nav-tab[href="' + hash + '"]').click(); 
    } else { 
        $('.ucmr-nav-tab').first().click(); 
    }

    // ============================================================
    // 1. AI MODEL DYNAMIC DROPDOWN
    // ============================================================
    var aiModels = {
        'gemini': ['gemini-1.5-pro-002', 'gemini-1.5-flash-002', 'gemini-1.5-pro', 'gemini-1.5-flash'],
        'chatgpt': ['gpt-4o', 'gpt-4o-mini', 'gpt-4-turbo', 'gpt-4'],
        'claude': ['claude-3-5-sonnet-20241022', 'claude-3-opus-20240229', 'claude-3-haiku-20240307'],
        'grok': ['grok-beta'],
        'deepseek': ['deepseek-chat'],
        'meta': ['llama3.1-70b']
    };

    function updateAIModels() {
        var provider = $('#ucmr-ai-provider-select').val();
        var models = aiModels[provider] || [];
        var select = $('#ucmr-ai-model-select');
        var currentVal = select.val();

        select.empty();
        if (models.length > 0) {
            $.each(models, function(index, value) {
                select.append($('<option>', { value: value, text : value }));
            });
            select.append($('<option>', { value: '', text: 'Custom / Other' }));
        } else {
            select.append($('<option>', { value: '', text: 'Default' }));
        }
        if(models.includes(currentVal)) select.val(currentVal);
    }

    $('#ucmr-ai-provider-select').on('change', updateAIModels);
    if($('#ucmr-ai-provider-select').length) setTimeout(updateAIModels, 500);

    // ============================================================
    // 2. WIZARD: SOURCE TOGGLES
    // ============================================================
    $(document).on('change', 'input[name="ucmr_input_mode"]', function() {
        var mode = $(this).val();
        $('.ucmr-source-panel').hide();
        $('#ucmr-mode-' + mode).show();
    });
    $('input[name="ucmr_input_mode"]:checked').trigger('change');


    // ============================================================
    // 3. SHARED SEARCH LOGIC (Multi-Select)
    // ============================================================

    function handleSearch(action, queryInputId, resultsContainerId) {
        var query = $(queryInputId).val();
        if(!query) { alert('Please enter a search term.'); return; }

        $(resultsContainerId).html('<div style="padding:10px; background:#f0f0f0;">Searching...</div>').show();

        $.ajax({
            url: ucmr_ajax_object.ajax_url,
            type: 'POST',
            timeout: 45000, // 45s timeout
            data: {
                action: action,
                _ajax_nonce: ucmr_ajax_object.nonce,
                query: query
            },
            success: function(res) {
                if(res.success) {
                    var html = '<p style="font-size:11px; color:#666; margin-bottom:5px;">Click items to select (Green = Selected):</p><div style="display:grid; grid-template-columns:repeat(auto-fill, minmax(160px, 1fr)); gap:10px;">';
                    
                    // YouTube Results
                    if(res.data.videos) {
                        $.each(res.data.videos, function(i, v) {
                            html += `
                                <div class="ucmr-search-item" data-url="https://www.youtube.com/watch?v=${v.id}" style="border:1px solid #ddd; padding:5px; cursor:pointer; background:#fff; border-radius:4px;">
                                    <div style="position:relative;">
                                        <img src="${v.thumbnail}" style="width:100%; height:auto; border-radius:3px;">
                                        <div class="ucmr-check" style="display:none; position:absolute; top:5px; right:5px; background:green; color:fff; border-radius:50%; width:20px; height:20px; text-align:center; line-height:20px;">✓</div>
                                    </div>
                                    <div style="font-size:11px; font-weight:bold; margin-top:5px; line-height:1.2;">${v.title}</div>
                                </div>`;
                        });
                    }
                    // Web Results
                    else if(res.data.articles) {
                        $.each(res.data.articles, function(i, a) {
                            html += `
                                <div class="ucmr-search-item" data-url="${a.link}" style="border:1px solid #ddd; padding:10px; cursor:pointer; background:#fff; border-radius:4px;">
                                    <div style="font-weight:bold; font-size:12px; color:#0073aa; margin-bottom:3px;">${a.title}</div>
                                    <div style="font-size:10px; color:#666; height:30px; overflow:hidden;">${a.snippet}</div>
                                    <div class="ucmr-check" style="display:none; color:green; font-weight:bold; font-size:10px; margin-top:5px;">✓ Selected</div>
                                </div>`;
                        });
                    }
                    html += '</div>';
                    $(resultsContainerId).html(html);
                } else {
                    $(resultsContainerId).html('<p style="color:red;">' + res.data.message + '</p>');
                }
            },
            error: function(xhr, status, error) {
                $(resultsContainerId).html('<p style="color:red;">Search Failed: ' + error + '</p>');
            }
        });
    }

    // Toggle Selection on Click
    $(document).on('click', '.ucmr-search-item', function() {
        $(this).toggleClass('ucmr-selected');
        
        if ($(this).hasClass('ucmr-selected')) {
            $(this).css('border', '2px solid #46b450').css('background', '#f0f6fc');
            $(this).find('.ucmr-check').show();
        } else {
            $(this).css('border', '1px solid #ddd').css('background', '#fff');
            $(this).find('.ucmr-check').hide();
        }
    });

    // Helper: Get selected values
    function getSelectedSources(containerId) {
        var selected = [];
        $(containerId + ' .ucmr-search-item.ucmr-selected').each(function() {
            selected.push($(this).data('url'));
        });
        return selected.join(',');
    }

    // Wizard Search Buttons
    $(document).on('click', '#ucmr-wiz-yt-search-btn', function(e) { e.preventDefault(); handleSearch('ucmr_search_youtube', '#ucmr-wiz-yt-query', '#ucmr-wiz-yt-results'); });
    $(document).on('click', '#ucmr-wiz-web-search-btn', function(e) { e.preventDefault(); handleSearch('ucmr_search_web', '#ucmr-wiz-web-query', '#ucmr-wiz-web-results'); });
    $(document).on('click', '#ucmr-wiz-url-fetch-btn', function(e) { e.preventDefault(); handleSearch('ucmr_fetch_url_articles', '#ucmr-wiz-direct-url', '#ucmr-wiz-url-results'); });

    // Scheduler Search Buttons
    $(document).on('click', '#ucmr-job-yt-search-btn', function(e) { e.preventDefault(); handleSearch('ucmr_search_youtube', '#ucmr-job-search-query', '#ucmr-job-search-results'); });
    $(document).on('click', '#ucmr-job-web-search-btn', function(e) { e.preventDefault(); handleSearch('ucmr_search_web', '#ucmr-job-search-query', '#ucmr-job-search-results'); });
    $(document).on('click', '#ucmr-job-url-fetch-btn', function(e) { e.preventDefault(); handleSearch('ucmr_fetch_url_articles', '#ucmr-job-search-query', '#ucmr-job-search-results'); });


    // ============================================================
    // 4. GENERATE PREVIEW (WIZARD)
    // ============================================================
    $(document).on('click', '#ucmr-wiz-generate-btn', function() {
        var mode = $('input[name="ucmr_input_mode"]:checked').val();
        var input = '';
        
        if(mode === 'keyword') {
            input = $('#ucmr-wiz-keyword').val();
        } else if(mode === 'youtube') {
            input = getSelectedSources('#ucmr-wiz-yt-results') || $('#ucmr-wiz-youtube-url-manual').val();
        } else if(mode === 'web') {
            input = getSelectedSources('#ucmr-wiz-web-results');
        } else if(mode === 'link') {
            input = getSelectedSources('#ucmr-wiz-url-results') || $('#ucmr-wiz-direct-url').val();
        }

        if(!input) { alert('Please enter a keyword or select at least one source.'); return; }

        var $btn = $(this).text('Generating Draft... (Please Wait)').prop('disabled', true);

        $.ajax({
            url: ucmr_ajax_object.ajax_url,
            type: 'POST',
            timeout: 120000, 
            data: {
                action: 'ucmr_preview_post',
                _ajax_nonce: ucmr_ajax_object.nonce,
                mode: mode,
                input: input,
                tone: $('#ucmr-wiz-tone').val(),
                length: $('#ucmr-wiz-length').val(),
                img_count: $('#ucmr-wiz-img-count').val(),
                img_source: $('#ucmr-wiz-img-source').val(),
                custom_prompt: $('#ucmr-wiz-custom-prompt').val(),
                aff_text: $('#ucmr-wiz-link-title').val(),
                aff_url: $('#ucmr-wiz-link-url').val(),
                podcast: $('#ucmr-wiz-podcast').is(':checked') ? 1 : 0,
                // Repurposing flags
                social_x: $('#ucmr-wiz-social-x').is(':checked')?1:0,
                social_fb: $('#ucmr-wiz-social-fb').is(':checked')?1:0,
                social_li: $('#ucmr-wiz-social-li').is(':checked')?1:0,
                social_ig: $('#ucmr-wiz-social-ig').is(':checked')?1:0,
                social_tt: $('#ucmr-wiz-social-tt').is(':checked')?1:0,
                social_yt: $('#ucmr-wiz-social-yt').is(':checked')?1:0
            },
            success: function(res) {
                if(res.success) {
                    $('#ucmr-wiz-title').val(res.data.title);
                    if(typeof tinymce !== 'undefined' && tinymce.get('ucmr-wiz-content')) {
                        tinymce.get('ucmr-wiz-content').setContent(res.data.content);
                    } else {
                        $('#ucmr-wiz-content').val(res.data.content);
                    }
                    $('#ucmr-wiz-publish-btn, #ucmr-wiz-draft-btn').prop('disabled', false);
                    $btn.text('Generate Preview').prop('disabled', false);
                } else {
                    alert('AI Error: ' + res.data.message);
                    $btn.text('Generate Preview').prop('disabled', false);
                }
            },
            error: function(xhr) { 
                alert('Request Timed Out. The AI is taking too long. Try fewer sources.'); 
                $btn.text('Generate Preview').prop('disabled', false); 
            }
        });
    });

    // ============================================================
    // 5. CHAINED PUBLISH (Wizard)
    // ============================================================
    function savePost(status) {
        var $btn = $('#ucmr-wiz-' + status + '-btn');
        $btn.text('Saving...').prop('disabled', true);
        $('#ucmr-wiz-status').html('Step 1/3: Saving Text...').show();

        var content = (typeof tinymce !== 'undefined' && tinymce.get('ucmr-wiz-content') && !$('#ucmr-wiz-content').is(':visible')) 
            ? tinymce.get('ucmr-wiz-content').getContent() 
            : $('#ucmr-wiz-content').val();

        // 1. Save Post
        $.post(ucmr_ajax_object.ajax_url, {
            action: 'ucmr_publish_post',
            _ajax_nonce: ucmr_ajax_object.nonce,
            title: $('#ucmr-wiz-title').val(),
            content: content,
            status: status,
            category_id: $('#ucmr-wiz-cat').val(),
            new_category: ($('#ucmr-wiz-cat').val() === 'new' ? $('#ucmr-wiz-new-cat').val() : ''),
            podcast: 0 // Defer audio
        }).done(function(res) {
            if(res.success) {
                var pid = res.data.post_id;
                $('#ucmr-wiz-status').html('Step 2/3: Processing Images...');
                
                // 2. Process Images
                $.post(ucmr_ajax_object.ajax_url, {
                    action: 'ucmr_process_images',
                    _ajax_nonce: ucmr_ajax_object.nonce,
                    post_id: pid,
                    keywords: $('#ucmr-wiz-title').val(),
                    count: $('#ucmr-wiz-img-count').val(),
                    source: $('#ucmr-wiz-img-source').val()
                }).done(function() {
                    
                    // 3. Process Audio (If checked)
                    if($('#ucmr-wiz-podcast').is(':checked')) {
                        $('#ucmr-wiz-status').html('Step 3/3: Generating Audio...');
                        $.post(ucmr_ajax_object.ajax_url, {
                            action: 'ucmr_process_audio',
                            _ajax_nonce: ucmr_ajax_object.nonce,
                            post_id: pid
                        }).done(function() {
                            $('#ucmr-wiz-status').html('<strong style="color:green">Success!</strong> <a href="'+res.data.edit_url+'" target="_blank">Edit Post</a>');
                        });
                    } else {
                        $('#ucmr-wiz-status').html('<strong style="color:green">Success!</strong> <a href="'+res.data.edit_url+'" target="_blank">Edit Post</a>');
                    }
                });
            } else {
                alert('Error: ' + res.data.message);
            }
        }).always(function(){ $btn.text(status === 'publish' ? 'Publish' : 'Draft').prop('disabled', false); });
    }
    
    $(document).on('click', '#ucmr-wiz-publish-btn', function() { savePost('publish'); });
    $(document).on('click', '#ucmr-wiz-draft-btn', function() { savePost('draft'); });


    // ============================================================
    // 6. SCHEDULER CREATE JOB
    // ============================================================
    $(document).on('click', '#ucmr-job-create-btn', function() {
        var name = $('#ucmr-job-name').val();
        var input = $('#ucmr-job-input').val();
        var selected = getSelectedSources('#ucmr-job-search-results');
        
        if(selected) { input = selected; } // Prefer selected checkboxes

        if(!name || !input) { alert('Enter Job Name and Input (or select sources).'); return; }
        
        $.post(ucmr_ajax_object.ajax_url, {
            action: 'ucmr_create_job',
            _ajax_nonce: ucmr_ajax_object.nonce,
            job_name: name,
            topic: input, // Can be comma-list
            source_type: $('#ucmr-job-source-type').val(),
            frequency: $('#ucmr-job-freq').val(),
            duration: $('#ucmr-job-duration').val(),
            
            category: $('#ucmr-job-cat').val(),
            tone: $('#ucmr-job-tone').val(),
            img_source: $('#ucmr-job-img-source').val(),
            img_count: $('#ucmr-job-img-count').val(),
            length: $('#ucmr-job-length').val(),
            link_title: $('#ucmr-job-link-title').val(),
            link_url: $('#ucmr-job-link-url').val(),
            custom_prompt: $('#ucmr-job-custom-prompt').val(),
            podcast: $('#ucmr-job-podcast').is(':checked') ? 1 : 0,
            // Socials
            social_x: $('#ucmr-job-social-x').is(':checked') ? 1 : 0,
            social_fb: $('#ucmr-job-social-fb').is(':checked') ? 1 : 0,
            social_li: $('#ucmr-job-social-li').is(':checked') ? 1 : 0,
            social_ig: $('#ucmr-job-social-ig').is(':checked') ? 1 : 0,
            social_tt: $('#ucmr-job-social-tt').is(':checked') ? 1 : 0,
            social_yt: $('#ucmr-job-social-yt').is(':checked') ? 1 : 0
        }).done(function(res) {
            if(res.success) { alert('Job Scheduled!'); location.reload(); }
            else { alert(res.data.message); }
        });
    });
    
    // Delete Job
    $(document).on('click', '.ucmr-job-delete', function() {
        if(confirm('Delete job?')) {
            $.post(ucmr_ajax_object.ajax_url, {
                action: 'ucmr_delete_job',
                _ajax_nonce: ucmr_ajax_object.nonce,
                id: $(this).data('id')
            }).done(function() { location.reload(); });
        }
    });

});