jQuery(document).ready(function($) {

    // --- 1. AI IMAGE EDITOR ---
    
    // Use delegated events
    $(document).on('click', '#ucmr-image-input-button', function(e) {
        e.preventDefault();
        $('#ucmr-image-input-file').trigger('click'); 
    });

    $(document).on('change', '#ucmr-image-input-file', function() {
        var file = this.files[0];
        if (file) {
            if (file.size > 4 * 1024 * 1024) {
                alert('File is too large (Max 4MB).');
                return;
            }
            
            var reader = new FileReader();
            reader.onload = function(e) {
                // Show Preview
                $('#ucmr-image-input-preview').attr('src', e.target.result).show();
                $('#ucmr-image-input-placeholder').hide();
                
                // Store Data for AJAX
                var base64 = e.target.result.split(',')[1];
                $('#ucmr-image-editor-generate-button')
                    .prop('disabled', false)
                    .data('base64', base64)
                    .data('mime', file.type);
            };
            reader.readAsDataURL(file);
        }
    });

    $(document).on('click', '#ucmr-image-editor-generate-button', function() {
        var prompt = $('#ucmr-image-editor-prompt').val();
        var base64 = $(this).data('base64');
        var mime = $(this).data('mime');
        
        if(!prompt) { alert('Please enter a prompt describing the edit.'); return; }
        
        var $btn = $(this).text('Generating... (Please Wait)').prop('disabled', true);
        
        $.post(ucmr_ajax_object.ajax_url, {
            action: 'ucmr_image_editor_generate',
            _ajax_nonce: ucmr_ajax_object.nonce,
            prompt: prompt,
            base64_image: base64,
            mime_type: mime
        }).done(function(res) {
            if(res.success) {
                $('#ucmr-image-output-preview').attr('src', res.data.image_data).show();
                $('#ucmr-image-output-placeholder').hide();
                $('#ucmr-image-editor-download-link').attr('href', res.data.image_data).show();
            } else {
                alert('Error: ' + res.data.message);
            }
        }).fail(function() {
            alert('Server Error or Timeout.');
        }).always(function(){ $btn.text('Generate Variation').prop('disabled', false); });
    });

    // --- 2. TRENDING CONTENT ---
    $(document).on('click', '.ucmr-trend-search', function() {
        var platform = $(this).data('platform');
        var query = $('#trend-' + platform + '-query').val();
        var $resDiv = $('#res-' + platform);
        
        if(!query) { alert('Enter keyword'); return; }
        
        var $btn = $(this).text('Searching...').prop('disabled', true);
        $resDiv.html('<small>Analyzing...</small>');

        $.post(ucmr_ajax_object.ajax_url, {
            action: 'ucmr_get_trends',
            _ajax_nonce: ucmr_ajax_object.nonce,
            topic: query,
            platform: platform
        }).done(function(res) {
            if(res.success) {
                var html = '<ul style="list-style:disc; padding-left:20px; font-size:12px;">';
                // Handle bullet points
                var items = res.data.trends.split('\n');
                $.each(items, function(i, item) {
                    if(item.trim()) {
                        // Clean up asterisks and numbers
                        var cleanText = item.replace(/^- /, '').replace(/^\d+\. /, '').replace(/\*/g, '');
                        html += '<li>' + cleanText + '</li>';
                    }
                });
                html += '</ul>';
                $resDiv.html(html);
            } else {
                $resDiv.text('Error: ' + res.data.message);
            }
        }).fail(function() {
            $resDiv.text('Connection Error.');
        }).always(function(){ $btn.text('Find Trends').prop('disabled', false); });
    });

    // --- 3. BACKEND CHATBOT ---
    $(document).on('click', '#ucmr-backend-chat-send', function() {
        var msg = $('#ucmr-backend-chat-input').val();
        if(!msg) return;
        
        $('#ucmr-backend-chat-messages').append('<div class="ucmr-chat-bubble ucmr-chat-user">'+msg+'</div>');
        $('#ucmr-backend-chat-input').val('');
        
        $.post(ucmr_ajax_object.ajax_url, {
            action: 'ucmr_backend_chat',
            _ajax_nonce: ucmr_ajax_object.nonce,
            message: msg
        }).done(function(res) {
            if(res.success) {
                $('#ucmr-backend-chat-messages').append('<div class="ucmr-chat-bubble ucmr-chat-ai">'+res.data.reply+'</div>');
            }
        });
    });

});