jQuery(document).ready(function($) {
    
    // Check if we are in the Classic Editor
    if (typeof tinymce === 'undefined' || typeof ucmr_post_tools_ajax === 'undefined') {
        // We're likely in Gutenberg or another editor.
        // Hide the tools to avoid confusion.
        $('#ucmr-post-tools').hide();
        return;
    }

    const grammarBtn = $('#ucmr-grammar-button');
    const puncBtn = $('#ucmr-punctuator-button');
    const responseBox = $('#ucmr-tools-response');

    function setButtonsDisabled(disabled) {
        grammarBtn.prop('disabled', disabled);
        puncBtn.prop('disabled', disabled);
    }

    function getEditorContent() {
        if ($('#wp-content-wrap').hasClass('tmce-active')) {
            // Visual editor
            return tinymce.get('content').getContent();
        } else {
            // Text editor
            return $('#content').val();
        }
    }

    function setEditorContent(text) {
        if ($('#wp-content-wrap').hasClass('tmce-active')) {
            // Visual editor
            tinymce.get('content').setContent(text);
        } else {
            // Text editor
            $('#content').val(text);
        }
    }

    // --- Grammar Correction ---
    grammarBtn.on('click', function() {
        const content = getEditorContent();
        if (content.trim() === '') {
            responseBox.text('Editor is empty.');
            return;
        }

        setButtonsDisabled(true);
        responseBox.text('Checking grammar...');

        $.post(ucmr_post_tools_ajax.ajax_url, {
            action: 'ucmr_grammar_check',
            _ajax_nonce: ucmr_post_tools_ajax.nonce,
            post_content: content
        })
        .done(function(response) {
            if (response.success) {
                setEditorContent(response.data.text);
                responseBox.text('Grammar corrected successfully.');
            } else {
                responseBox.text('Error: ' + response.data.message);
            }
        })
        .fail(function() {
            responseBox.text('Server error. Please try again.');
        })
        .always(function() {
            setButtonsDisabled(false);
        });
    });

    // --- Punctuation ---
    puncBtn.on('click', function() {
        const content = getEditorContent();
        if (content.trim() === '') {
            responseBox.text('Editor is empty.');
            return;
        }

        setButtonsDisabled(true);
        responseBox.text('Adding punctuation...');

        $.post(ucmr_post_tools_ajax.ajax_url, {
            action: 'ucmr_punctuator_check',
            _ajax_nonce: ucmr_post_tools_ajax.nonce,
            post_content: content
        })
        .done(function(response) {
            if (response.success) {
                setEditorContent(response.data.text);
                responseBox.text('Punctuation added successfully.');
            } else {
                responseBox.text('Error: ' + response.data.message);
            }
        })
        .fail(function() {
            responseBox.text('Server error. Please try again.');
        })
        .always(function() {
            setButtonsDisabled(false);
        });
    });

});