<?php
/**
 * Renders the Analytics admin page.
 *
 * This is a placeholder for a full analytics dashboard.
 * The database table `ucmr_page_views` is created on activation.
 * A full implementation would involve:
 * 1. A JS script to fire 'click' events on ads and send to an AJAX handler.
 * 2. An AJAX handler to log 'click' events to the database.
 * 3. Complex DB queries here to aggregate and display the data.
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
    die;
}

global $wpdb;
$table_name = $wpdb->prefix . 'ucmr_page_views';

// Example query: Get total views
$total_views = $wpdb->get_var( "SELECT COUNT(id) FROM $table_name" );

// Example query: Get top 5 viewed posts
$top_posts = $wpdb->get_results( $wpdb->prepare(
    "SELECT post_id, COUNT(id) AS views FROM $table_name GROUP BY post_id ORDER BY views DESC LIMIT %d",
    5
) );

?>

<div class="wrap ucmr-admin-page">
    <h1 class="wp-heading-inline">Analytics Dashboard</h1>
    <p>This is the central hub for your content and ad performance. The view tracker is active.</p>

    <div class="ucmr-analytics-grid">
        <div class="ucmr-analytics-stat-card">
            <h2>Total Tracked Page Views</h2>
            <div class="ucmr-analytics-stat-number"><?php echo number_format( $total_views ); ?></div>
        </div>

        <div class="ucmr-analytics-stat-card">
            <h2>Top 5 Viewed Posts</h2>
            <?php if ( empty( $top_posts ) ) : ?>
                <p>No data yet.</p>
            <?php else : ?>
                <ol>
                    <?php foreach ( $top_posts as $post_data ) : ?>
                        <li>
                            <a href="<?php echo esc_url( get_permalink( $post_data->post_id ) ); ?>" target="_blank">
                                <?php echo esc_html( get_the_title( $post_data->post_id ) ); ?>
                            </a>
                            (<?php echo number_format( $post_data->views ); ?> views)
                        </li>
                    <?php endforeach; ?>
                </ol>
            <?php endif; ?>
        </div>

        <div class="ucmr-analytics-stat-card">
            <h2>Ad Click Tracking</h2>
            <p>Ad click tracking and "Quick Wins" / "Scale Opportunities" would be implemented here.</p>
            <p>This requires a custom JavaScript listener to be added to the frontend to capture clicks on `.ucmr-ad-container` elements and report them back via AJAX to be stored and analyzed.</p>
            <span class="ucmr-tag-premium">Advanced Feature</span>
        </div>
    </div>
</div>

<style>
    .ucmr-analytics-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 20px;
        margin-top: 20px;
    }
    .ucmr-analytics-stat-card {
        background: #fff;
        padding: 25px;
        border-radius: var(--ucmr-radius);
        box-shadow: var(--ucmr-shadow);
    }
    .ucmr-analytics-stat-card h2 {
        margin-top: 0;
        font-size: 1.2em;
    }
    .ucmr-analytics-stat-number {
        font-size: 3em;
        font-weight: 700;
        color: var(--ucmr-primary);
    }
    .ucmr-analytics-stat-card ol {
        margin-bottom: 0;
        padding-left: 20px;
    }
    .ucmr-analytics-stat-card li {
        margin-bottom: 10px;
    }
</style>