<?php
/**
 * Renders the AI Image Editor admin page.
 * This tool uses gemini-2.5-flash-image-preview (Nano-Banana) for image-to-image editing.
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
    die;
}

?>

<div class="wrap ucmr-admin-page">
    <h1 class="wp-heading-inline">AI Image Editor (Nano-Banana)</h1>
    <p>Upload a sample image, provide a prompt, and the AI will generate a new variation.</p>

    <div class="ucmr-image-editor-container">
        <!-- Input Column -->
        <div class="ucmr-image-editor-panel">
            <h2>1. Input Sample</h2>
            
            <div class="ucmr-image-preview-box" id="ucmr-image-input-preview-box">
                <img id="ucmr-image-input-preview" src="" alt="Input preview" style="display: none;">
                <span id="ucmr-image-input-placeholder">Upload an image (JPG, PNG)</span>
            </div>

            <input type.file" id="ucmr-image-input-file" accept="image/png, image/jpeg" style="display: none;">
            <button class="ucmr-btn-secondary" id="ucmr-image-input-button" type="button">Click to Upload Image</button>

            <label for="ucmr-image-editor-prompt" class="ucmr-label" style="margin-top: 20px;">2. Edit Prompt</label>
            <textarea id="ucmr-image-editor-prompt" class="ucmr-textarea-field" rows="4" placeholder="e.g., 'Make this a watercolor painting', 'Change the background to a sunny beach', 'Add a small red bird on the branch'"></textarea>

            <button class="ucmr-btn-primary" id="ucmr-image-editor-generate-button" type="button" disabled>
                Generate Variation
            </button>
        </div>

        <!-- Output Column -->
        <div class="ucmr-image-editor-panel">
            <h2>3. AI-Generated Variation</h2>
            
            <div class="ucmr-image-preview-box" id="ucmr-image-output-preview-box">
                <img id="ucmr-image-output-preview" src="" alt="Output preview" style="display: none;">
                <div id="ucmr-image-output-placeholder">
                    Your generated image will appear here...
                </div>
                <div class="ucmr-spinner" id="ucmr-image-editor-spinner" style="display: none;"></div>
            </div>

            <a id="ucmr-image-editor-download-link" class="ucmr-btn-secondary" href="#" download="ai-variation.png" style="display: none; text-align: center;">
                Download Image
            </a>
        </div>
    </div>
</div>

<style>
    .ucmr-image-editor-container {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 20px;
        margin-top: 20px;
    }
    .ucmr-image-editor-panel {
        background: #fff;
        padding: 25px;
        border-radius: var(--ucmr-radius);
        box-shadow: var(--ucmr-shadow);
        display: flex;
        flex-direction: column;
    }
    .ucmr-image-preview-box {
        width: 100%;
        height: 300px;
        background: var(--ucmr-bg-lighter);
        border: 2px dashed var(--ucmr-border-color);
        border-radius: var(--ucmr-radius);
        display: flex;
        align-items: center;
        justify-content: center;
        overflow: hidden;
        position: relative;
    }
    .ucmr-image-preview-box img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }
    #ucmr-image-input-placeholder,
    #ucmr-image-output-placeholder {
        color: var(--ucmr-text-muted);
        text-align: center;
        padding: 20px;
    }
    .ucmr-image-editor-panel button {
        margin-top: 15px;
    }
    .ucmr-spinner {
        border: 4px solid #f3f3f3;
        border-top: 4px solid var(--ucmr-primary);
        border-radius: 50%;
        width: 40px;
        height: 40px;
        animation: ucmr-spin 1s linear infinite;
        position: absolute;
    }
    @keyframes ucmr-spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
    @media (max-width: 900px) {
        .ucmr-image-editor-container {
            grid-template-columns: 1fr;
        }
    }
</style>