/**
 * JavaScript for the Frontend Text-to-Speech (TTS) Player
 * Uses the browser's built-in SpeechSynthesis API
 */
document.addEventListener('DOMContentLoaded', function() {
    
    const player = document.getElementById('ucmr-tts-player');
    if (!player) {
        return; // Player not found on this page
    }

    const playBtn = document.getElementById('ucmr-tts-play');
    const pauseBtn = document.getElementById('ucmr-tts-pause');
    const stopBtn = document.getElementById('ucmr-tts-stop');
    const ttsText = document.getElementById('ucmr-tts-text');

    const synth = window.speechSynthesis;
    let utterance = null;

    // Get the post content text
    const textToSpeak = ttsText.textContent.trim();
    if (textToSpeak === '') {
        player.style.display = 'none'; // No text, hide player
        return;
    }

    // Create the utterance object
    utterance = new SpeechSynthesisUtterance(textToSpeak);
    
    // --- Event Listeners for Buttons ---
    
    playBtn.addEventListener('click', () => {
        if (synth.paused) {
            synth.resume(); // Resume if paused
        } else {
            synth.cancel(); // Cancel any previous speech
            synth.speak(utterance); // Start speaking
        }
        playBtn.style.display = 'none';
        pauseBtn.style.display = 'inline-block';
    });

    pauseBtn.addEventListener('click', () => {
        synth.pause();
        playBtn.style.display = 'inline-block';
        pauseBtn.style.display = 'none';
    });

    stopBtn.addEventListener('click', () => {
        synth.cancel();
        playBtn.style.display = 'inline-block';
        pauseBtn.style.display = 'none';
    });

    // Reset buttons when speech ends
    utterance.onend = () => {
        playBtn.style.display = 'inline-block';
        pauseBtn.style.display = 'none';
    };

    // Ensure speech is cancelled if the user leaves the page
    window.addEventListener('beforeunload', () => {
        synth.cancel();
    });

});