<?php
if ( ! defined( 'WPINC' ) ) { die; }

class UCMR_Ad_Injector {
    private $options;

    public function __construct( $options ) {
        $this->options = $options;
        if ( is_admin() ) return;
        $this->add_placement_hooks();
    }

    private function add_placement_hooks() {
        add_action( 'loop_start', [ $this, 'inject_top_of_site_ad' ], 10 );
        // Removed 'the_title' filter as it often breaks themes. Using loop_start or content is safer.
        add_filter( 'the_content', [ $this, 'inject_content_ads' ], 20 );
    }

    private function get_weighted_random_ad( $placement_prefix ) {
        $enabled_ads = [];
        $total_weight = 0;

        // Loop 1 to 5
        for ( $i = 1; $i <= 5; $i++ ) {
            $enable_key = $placement_prefix . '_' . $i . '_enable';
            $code_key   = $placement_prefix . '_' . $i . '_code';
            $freq_key   = $placement_prefix . '_' . $i . '_freq';

            if ( ! empty( $this->options[ $enable_key ] ) && $this->options[ $enable_key ] === '1' && ! empty( $this->options[ $code_key ] ) ) {
                $weight = absint( $this->options[ $freq_key ] ?? 10 );
                if( $weight <= 0 ) $weight = 1; // Prevent 0 weight
                
                $enabled_ads[] = [
                    'code' => $this->options[ $code_key ],
                    'weight' => $weight
                ];
                $total_weight += $weight;
            }
        }

        if ( empty( $enabled_ads ) ) return '';

        // Weighted Random Selection
        $rand = mt_rand( 1, $total_weight );
        foreach ( $enabled_ads as $ad ) {
            $rand -= $ad['weight'];
            if ( $rand <= 0 ) {
                return $ad['code'];
            }
        }
        
        return $enabled_ads[0]['code']; // Fallback
    }

    public function inject_top_of_site_ad( $query ) {
        if ( $query->is_main_query() && $query->is_home() && $query->in_the_loop ) {
            $ad_code = $this->get_weighted_random_ad( 'ads_top' );
            if($ad_code) {
                $float = $this->options['ads_top_float'] ?? 'none';
                $style = ($float === 'none') ? 'text-align:center; margin:20px 0;' : "float:$float; margin:10px;";
                echo '<div class="ucmr-ad-container" style="'.$style.'">' . do_shortcode( $ad_code ) . '</div>';
            }
        }
    }

    public function inject_content_ads( $content ) {
        if ( ! is_main_query() || ! in_the_loop() || ! is_singular( 'post' ) ) return $content;

        // In-Content
        $ad_in = $this->get_weighted_random_ad( 'ads_content' );
        if ( $ad_in ) {
            $p_num = absint( $this->options['ads_content_p'] ?? 3 );
            $float = $this->options['ads_content_float'] ?? 'none';
            $style = ($float === 'none') ? 'text-align:center; margin:20px 0;' : "float:$float; margin:10px;";
            $ad_html = '<div class="ucmr-ad-container" style="'.$style.'">' . do_shortcode( $ad_in ) . '</div>';
            
            $content_parts = explode( '</p>', $content );
            if ( count( $content_parts ) > $p_num ) {
                array_splice( $content_parts, $p_num, 0, $ad_html );
                $content = implode( '</p>', $content_parts );
            } else {
                $content .= $ad_html;
            }
        }
        
        // Below Post
        $ad_below = $this->get_weighted_random_ad( 'ads_bottom' );
        if ( $ad_below ) {
            $content .= '<div class="ucmr-ad-container" style="text-align:center; margin-top:30px;">' . do_shortcode( $ad_below ) . '</div>';
        }

        return $content;
    }
}