<?php
/**
 * Renders the main settings page for Ultimate Content Money River.
 * This file contains the complete HTML and inline CSS/JS for the tabbed interface.
 */

if ( ! defined( 'WPINC' ) ) {
    die;
}

// Get the full options array to populate the fields
$options = get_option( 'ucmr_options' );
$categories = get_categories( ['hide_empty' => false] );
$authors = get_users( ['role__in' => ['administrator', 'editor', 'author']] );
$is_premium = ucmr_is_premium_user();

global $wpdb;
// Fetch scheduled jobs safely
$table_jobs = $wpdb->prefix . 'ucmr_scheduled_jobs';
// Check if table exists to avoid errors on fresh install before activation hook runs
if($wpdb->get_var("SHOW TABLES LIKE '$table_jobs'") == $table_jobs) {
    $jobs = $wpdb->get_results( "SELECT * FROM $table_jobs ORDER BY id DESC" );
} else {
    $jobs = [];
}
?>

<style>
    /* Admin-specific styles for the settings page */
    :root {
        --ucmr-primary: #0073aa; /* WordPress Blue */
        --ucmr-primary-hover: #006190;
        --ucmr-secondary: #f0f0f1;
        --ucmr-secondary-hover: #e5e5e6;
        --ucmr-bg-lighter: #f8f9fa;
        --ucmr-border-color: #ddd;
        --ucmr-text-dark: #2c3338;
        --ucmr-text-muted: #555d66;
        --ucmr-radius: 4px;
        --ucmr-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        --ucmr-success: #28a745;
        --ucmr-error: #dc3545;
    }

    .ucmr-admin-page .wrap { margin: 20px; background: #fff; padding: 20px; box-shadow: 0 1px 3px rgba(0,0,0,0.1); }
    .ucmr-admin-page h1 { display: flex; align-items: center; gap: 15px; margin-bottom: 20px; }
    .ucmr-version-tag { font-size: 12px; background: var(--ucmr-secondary); color: var(--ucmr-text-muted); padding: 3px 8px; border-radius: var(--ucmr-radius); }
    
    .ucmr-admin-grid { display: grid; grid-template-columns: 2fr 1fr; gap: 20px; }
    .ucmr-grid-2 { display: grid; grid-template-columns: 1fr 1fr; gap: 15px; }

    @media (max-width: 900px) { .ucmr-admin-grid, .ucmr-grid-2 { grid-template-columns: 1fr; } }

    /* Tab Navigation */
    .ucmr-nav-tab-wrapper { border-bottom: 1px solid var(--ucmr-border-color); padding-left: 10px; margin-top: 20px; }
    .ucmr-nav-tab { display: inline-block; padding: 10px 15px; background: var(--ucmr-secondary); border: 1px solid var(--ucmr-border-color); border-bottom: none; margin-right: 5px; text-decoration: none; color: var(--ucmr-text-muted); font-size: 14px; font-weight: 600; border-radius: var(--ucmr-radius) var(--ucmr-radius) 0 0; position: relative; top: 1px; }
    .ucmr-nav-tab:hover { background: var(--ucmr-secondary-hover); color: var(--ucmr-text-dark); }
    .ucmr-nav-tab.ucmr-nav-tab-active { background: #fff; border-bottom: 1px solid #fff; color: var(--ucmr-text-dark); }

    /* Tab Content */
    .ucmr-tab-content { display: none; background: #fff; padding: 20px; border: 1px solid var(--ucmr-border-color); border-top: none; }
    .ucmr-tab-content-active { display: block; }
    .ucmr-tab-content h2 { margin-top: 0; font-size: 1.5em; padding-bottom: 10px; border-bottom: 1px solid var(--ucmr-border-color); }
    
    /* Form Elements */
    .ucmr-form-row { margin-bottom: 15px; }
    .ucmr-label { display: block; font-weight: 600; margin-bottom: 5px; font-size: 13px; }
    .ucmr-input-field, .ucmr-textarea-field { width: 100%; max-width: 100%; padding: 8px 12px; border: 1px solid var(--ucmr-border-color); border-radius: var(--ucmr-radius); box-shadow: 0 1px 2px rgba(0, 0, 0, 0.07) inset; font-size: 14px; box-sizing: border-box; }
    .ucmr-textarea-field { min-height: 80px; resize: vertical; }
    .ucmr-description { font-size: 13px; color: var(--ucmr-text-muted); margin: 5px 0 0 0; font-style: italic; }

    /* Cards */
    .ucmr-card { background: var(--ucmr-bg-lighter); border: 1px solid var(--ucmr-border-color); border-radius: var(--ucmr-radius); padding: 20px; box-shadow: var(--ucmr-shadow); margin-bottom: 20px; }
    .ucmr-card h2, .ucmr-card h3 { margin-top: 0; padding-bottom: 10px; border-bottom: 1px solid var(--ucmr-border-color); }

    /* Buttons */
    .ucmr-btn-primary { background: var(--ucmr-primary) !important; border-color: var(--ucmr-primary-hover) !important; color: #fff !important; padding: 8px 15px !important; font-size: 14px !important; font-weight: 600 !important; height: auto !important; border-radius: var(--ucmr-radius) !important; cursor: pointer; text-decoration: none; transition: background 0.2s ease; }
    .ucmr-btn-primary:hover { background: var(--ucmr-primary-hover) !important; }
    .ucmr-btn-primary:disabled { background: #a0a5aa !important; border-color: #a0a5aa !important; cursor: not-allowed; opacity: 0.7; }
    .ucmr-btn-secondary { background: var(--ucmr-secondary) !important; border-color: var(--ucmr-border-color) !important; color: var(--ucmr-text-dark) !important; padding: 8px 15px; font-size: 14px; font-weight: 600; border-radius: var(--ucmr-radius); cursor: pointer; text-decoration: none; display: inline-block; }
    .ucmr-btn-secondary:hover { background: var(--ucmr-secondary-hover) !important; }

    /* Ad Slots */
    .ucmr-ad-slot { background: #fff; border: 1px solid var(--ucmr-border-color); border-radius: var(--ucmr-radius); padding: 15px; margin-bottom: 15px; }
    .ucmr-ad-slot-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 10px; }

    /* Switch */
    .ucmr-switch { position: relative; display: inline-block; width: 36px; height: 20px; vertical-align: middle; }
    .ucmr-switch input { opacity: 0; width: 0; height: 0; }
    .ucmr-slider { position: absolute; cursor: pointer; top: 0; left: 0; right: 0; bottom: 0; background-color: #ccc; transition: .4s; border-radius: 34px; }
    .ucmr-slider:before { position: absolute; content: ""; height: 14px; width: 14px; left: 3px; bottom: 3px; background-color: white; transition: .4s; border-radius: 50%; }
    input:checked + .ucmr-slider { background-color: var(--ucmr-primary); }
    input:checked + .ucmr-slider:before { transform: translateX(16px); }

    /* Source Panels */
    .ucmr-source-panel { background: #fff; padding: 15px; border: 1px solid var(--ucmr-border-color); border-radius: var(--ucmr-radius); margin-bottom: 15px; }
    
    /* Tags & Response */
    .ucmr-tag-premium { background: #ffb900; color: #000; font-size: 10px; font-weight: 700; padding: 2px 6px; border-radius: 3px; text-transform: uppercase; margin-left: 8px; vertical-align: middle; }
    .ucmr-response-box { padding: 15px; border-radius: var(--ucmr-radius); border: 1px solid; margin-bottom: 15px; font-weight: 600; }
    .ucmr-response-success { background: #f0fff4; border-color: var(--ucmr-success); color: var(--ucmr-success); }
    .ucmr-response-error { background: #fff0f0; border-color: var(--ucmr-error); color: var(--ucmr-error); }
    .notice-error { border-left-color: #d63638; background: #fff; box-shadow: 0 1px 1px 0 rgba(0,0,0,.1); padding: 10px 12px; margin: 5px 0 15px; }
</style>

<div class="wrap ucmr-admin-page">
    <h1>Ultimate Content Money River <span class="ucmr-version-tag">v<?php echo esc_html( UCMR_VERSION ); ?></span></h1>

    <div class="ucmr-nav-tab-wrapper">
        <a href="#wizard" class="ucmr-nav-tab ucmr-nav-tab-active">Single Article Wizard</a>
        <a href="#autopilot" class="ucmr-nav-tab" style="color: #d63638;">Content Scheduler (Premium)</a>
        <a href="#connections" class="ucmr-nav-tab">Social Connections</a>
        <a href="#ai-config" class="ucmr-nav-tab">AI Config</a>
        <a href="#global" class="ucmr-nav-tab">Global Settings</a>
        <a href="#ads" class="ucmr-nav-tab">Ad Placements</a>
        <a href="#license" class="ucmr-nav-tab">License</a>
    </div>

    <form method="post" action="options.php">
        <?php settings_fields( 'ucmr_options_group' ); ?>
        <div id="ucmr-tab-content-container">

            <!-- TAB 1: SINGLE ARTICLE WIZARD -->
            <div id="wizard" class="ucmr-tab-content ucmr-tab-content-active">
                <div class="ucmr-admin-grid">
                    <div class="ucmr-card">
                        <h2>1. Content Source</h2>
                        
                        <div style="margin-bottom:15px; display:flex; gap:15px; flex-wrap:wrap;">
                            <label><input type="radio" name="ucmr_input_mode" value="keyword" checked> Keyword</label>
                            <label><input type="radio" name="ucmr_input_mode" value="youtube"> YouTube Search</label>
                            <label><input type="radio" name="ucmr_input_mode" value="web"> Web Search</label>
                            <label><input type="radio" name="ucmr_input_mode" value="link"> Direct Link</label>
                        </div>

                        <!-- Keyword Mode -->
                        <div id="ucmr-mode-keyword" class="ucmr-source-panel">
                            <label class="ucmr-label">Enter Keywords / Topic</label>
                            <textarea id="ucmr-wiz-keyword" class="ucmr-textarea-field" rows="2" placeholder="e.g. Future of AI Marketing..."></textarea>
                        </div>

                        <!-- YouTube Mode -->
                        <div id="ucmr-mode-youtube" class="ucmr-source-panel" style="display:none;">
                            <label class="ucmr-label">Search YouTube</label>
                            <div style="display:flex; gap:10px;">
                                <input type="text" id="ucmr-wiz-yt-query" class="ucmr-input-field" placeholder="Search for trending videos...">
                                <button type="button" id="ucmr-wiz-yt-search-btn" class="ucmr-btn-secondary">Search</button>
                            </div>
                            <div id="ucmr-wiz-yt-results" style="max-height:300px; overflow-y:auto; margin-top:10px;"></div>
                            <label class="ucmr-label" style="margin-top:10px;">Or Paste URL:</label>
                            <input type="url" id="ucmr-wiz-youtube-url-manual" class="ucmr-input-field" placeholder="https://...">
                        </div>

                        <!-- Web Search Mode -->
                        <div id="ucmr-mode-web" class="ucmr-source-panel" style="display:none;">
                            <label class="ucmr-label">Search for Popular Articles</label>
                            <p class="ucmr-description">Click articles to select them as context sources.</p>
                            <div style="display:flex; gap:10px;">
                                <input type="text" id="ucmr-wiz-web-query" class="ucmr-input-field" placeholder="Topic...">
                                <button type="button" id="ucmr-wiz-web-search-btn" class="ucmr-btn-secondary">Search</button>
                            </div>
                            <div id="ucmr-wiz-web-results" style="max-height:300px; overflow-y:auto; margin-top:10px;"></div>
                        </div>

                        <!-- Direct Link Mode -->
                        <div id="ucmr-mode-link" class="ucmr-source-panel" style="display:none;">
                            <label class="ucmr-label">Article / TikTok URL</label>
                            <input type="url" id="ucmr-wiz-direct-url" class="ucmr-input-field" placeholder="https://example.com/article or https://tiktok.com/...">
                            <p class="ucmr-description">The AI will analyze this page content.</p>
                        </div>
                        
                        <hr style="margin:20px 0; border:0; border-top:1px solid #eee;">

                        <h2>2. Article Configuration</h2>
                        <div class="ucmr-grid-2">
                            <div>
                                <label class="ucmr-label">Category</label>
                                <select id="ucmr-wiz-cat" class="ucmr-input-field">
                                    <?php foreach($categories as $c) echo "<option value='{$c->term_id}'>{$c->name}</option>"; ?>
                                    <option value="new">+ New</option>
                                </select>
                                <input type="text" id="ucmr-wiz-new-cat" class="ucmr-input-field" style="display:none; margin-top:5px;" placeholder="New Category Name">
                            </div>
                            <div>
                                <label class="ucmr-label">Author</label>
                                <select id="ucmr-wiz-author" class="ucmr-input-field">
                                    <?php foreach($authors as $a) echo "<option value='{$a->ID}'>{$a->display_name}</option>"; ?>
                                </select>
                            </div>
                        </div>

                        <div class="ucmr-grid-2" style="margin-top:10px;">
                            <div>
                                <label class="ucmr-label">Tone</label>
                                <select id="ucmr-wiz-tone" class="ucmr-input-field">
                                    <option value="professional">Professional</option>
                                    <option value="humorous">Humorous</option>
                                    <option value="casual">Casual</option>
                                    <option value="authoritative">Authoritative</option>
                                    <option value="empathetic">Empathetic</option>
                                </select>
                            </div>
                            <div>
                                <label class="ucmr-label">Image Source</label>
                                <select id="ucmr-wiz-img-source" class="ucmr-input-field">
                                    <option value="royalty">Royalty Free</option>
                                    <option value="ai">AI Generated</option>
                                    <option value="hybrid">Hybrid</option>
                                </select>
                            </div>
                        </div>

                        <div class="ucmr-grid-2" style="margin-top:10px;">
                            <div>
                                <label class="ucmr-label">Image Count</label>
                                <input type="number" id="ucmr-wiz-img-count" class="ucmr-input-field" value="2" min="0" max="10">
                            </div>
                            <div>
                                <label class="ucmr-label">Length (Words)</label>
                                <input type="number" id="ucmr-wiz-length" class="ucmr-input-field" value="1500" step="100">
                            </div>
                        </div>

                        <label class="ucmr-label" style="margin-top:15px;">Auto-Insert Affiliate Link</label>
                        <div class="ucmr-grid-2">
                            <input type="text" id="ucmr-wiz-link-title" class="ucmr-input-field" placeholder="Link Text">
                            <input type="url" id="ucmr-wiz-link-url" class="ucmr-input-field" placeholder="https://...">
                        </div>
                        
                        <div class="ucmr-form-row" style="margin-top:15px;">
                            <label class="ucmr-label">Custom AI Instructions</label>
                            <textarea id="ucmr-wiz-custom-prompt" class="ucmr-textarea-field" rows="2" placeholder="Optional: Add extra guidance (e.g., 'Use a friendly voice', 'Focus on data', 'No jargon')..."></textarea>
                        </div>

                        <div class="ucmr-form-row" style="margin-top:15px;">
                            <label class="ucmr-label">
                                <input type="checkbox" id="ucmr-wiz-podcast" <?php checked($options['style_auto_audio']??0, 1); ?>> Generate Podcast Audio?
                            </label>
                        </div>
                        
                        <div class="ucmr-form-row">
                             <label class="ucmr-label">Auto-Repurpose & Post to:</label>
                             <div style="display:flex; gap:10px; flex-wrap:wrap;">
                                 <label><input type="checkbox" id="ucmr-wiz-social-x" checked> X</label>
                                 <label><input type="checkbox" id="ucmr-wiz-social-fb" checked> FB</label>
                                 <label><input type="checkbox" id="ucmr-wiz-social-li" checked> Linked</label>
                                 <label><input type="checkbox" id="ucmr-wiz-social-ig"> IG</label>
                                 <label><input type="checkbox" id="ucmr-wiz-social-tt"> TikTok</label>
                                 <label><input type="checkbox" id="ucmr-wiz-social-yt"> YouTube</label>
                             </div>
                             <p class="ucmr-description">Requires connected accounts in 'Social Connections'.</p>
                        </div>

                        <button type="button" id="ucmr-wiz-generate-btn" class="ucmr-btn-primary" style="width:100%; margin-top:20px;">Generate Preview</button>
                    </div>
                    
                    <div class="ucmr-card">
                        <h2>3. Editor & Publish</h2>
                        <input type="text" id="ucmr-wiz-title" class="ucmr-input-field" placeholder="Title...">
                        
                        <div style="margin-top:10px;">
                            <?php 
                            if( function_exists('wp_editor') ) {
                                wp_editor('', 'ucmr_wiz_content', ['textarea_name' => 'ucmr_wiz_content', 'editor_height' => 450, 'media_buttons' => false]);
                            } else {
                                echo '<textarea id="ucmr-wiz-content" class="ucmr-textarea-field" style="height:450px;" placeholder="Content..."></textarea>';
                            }
                            ?>
                        </div>

                        <div style="margin-top:15px;">
                            <button type="button" id="ucmr-wiz-publish-btn" class="ucmr-btn-primary" disabled>Publish Article</button>
                            <button type="button" id="ucmr-wiz-draft-btn" class="ucmr-btn-secondary" disabled>Save Draft</button>
                        </div>
                        <div id="ucmr-wiz-status" class="ucmr-response-box" style="display:none; margin-top:10px;"></div>
                    </div>
                </div>
            </div>

            <!-- TAB 2: AUTO-POSTING SCHEDULER -->
            <div id="autopilot" class="ucmr-tab-content">
                <div class="ucmr-admin-grid" style="<?php echo !$is_premium ? 'opacity: 0.5; pointer-events: none;' : ''; ?>">
                    <div class="ucmr-card">
                        <h2>Create Auto-Posting Job</h2>
                        <label class="ucmr-label">Job Name</label>
                        <input type="text" id="ucmr-job-name" class="ucmr-input-field" placeholder="e.g. Daily Tech News">
                        
                        <!-- Search Tool -->
                        <div style="background:#f9f9f9; border:1px solid #ddd; padding:10px; margin-top:10px; border-radius:4px;">
                            <p style="margin:0 0 5px; font-weight:bold;">Source Research</p>
                            <div style="display:flex; gap:5px;">
                                <input type="text" id="ucmr-job-search-query" class="ucmr-input-field" placeholder="Search YouTube/Web..." style="font-size:12px;">
                                <button type="button" id="ucmr-job-yt-search-btn" class="ucmr-btn-secondary" style="font-size:11px;">YouTube</button>
                                <button type="button" id="ucmr-job-web-search-btn" class="ucmr-btn-secondary" style="font-size:11px;">Web</button>
                            </div>
                            <div id="ucmr-job-search-results" style="max-height:150px; overflow-y:auto; margin-top:5px; font-size:11px;"></div>
                        </div>

                        <label class="ucmr-label" style="margin-top:10px;">Content Source Type</label>
                        <select id="ucmr-job-source-type" class="ucmr-input-field">
                            <option value="keyword">Keyword / Topic</option>
                            <option value="youtube_channel">YouTube Channel URL</option>
                            <option value="web_search">Web Search (Trending Topics)</option>
                            <option value="tiktok_search">TikTok Search/Trend</option>
                            <option value="link">Specific Link (Web/Video)</option>
                        </select>
                        
                        <label class="ucmr-label" style="margin-top:10px;">Input (Keyword/URL)</label>
                        <textarea id="ucmr-job-input" class="ucmr-textarea-field" rows="2" placeholder="Selected URLs or Keywords will go here..."></textarea>

                        <div class="ucmr-grid-2" style="margin-top:10px;">
                            <div>
                                <label class="ucmr-label">Frequency</label>
                                <select id="ucmr-job-freq" class="ucmr-input-field">
                                    <option value="daily">Daily</option>
                                    <option value="weekly">Weekly</option>
                                    <option value="monthly">Monthly</option>
                                </select>
                            </div>
                            <div>
                                <label class="ucmr-label">Publish Time</label>
                                <input type="time" id="ucmr-job-time" class="ucmr-input-field" value="09:00">
                            </div>
                        </div>
                        <p class="ucmr-description">Articles are generated 1 day before publishing date.</p>

                        <hr style="margin:15px 0; border-top:1px solid #eee;">
                        
                        <div class="ucmr-grid-2">
                            <div><label class="ucmr-label">Category</label><select id="ucmr-job-cat" class="ucmr-input-field"><?php foreach($categories as $c) echo "<option value='{$c->term_id}'>{$c->name}</option>"; ?></select></div>
                            <div><label class="ucmr-label">Tone</label><select id="ucmr-job-tone" class="ucmr-input-field"><option value="professional">Professional</option><option value="humorous">Humorous</option></select></div>
                        </div>
                        
                        <div class="ucmr-grid-2" style="margin-top:10px;">
                             <div><label class="ucmr-label">Image Source</label><select id="ucmr-job-img-source" class="ucmr-input-field"><option value="hybrid">Hybrid</option><option value="ai">AI</option></select></div>
                             <div><label class="ucmr-label">Image Count</label><input type="number" id="ucmr-job-img-count" class="ucmr-input-field" value="2"></div>
                        </div>
                        
                        <div class="ucmr-grid-2" style="margin-top:10px;">
                            <div><label class="ucmr-label">Length</label><input type="number" id="ucmr-job-length" class="ucmr-input-field" value="1500"></div>
                        </div>
                        
                        <label class="ucmr-label" style="margin-top:10px;">Affiliate Link</label>
                        <div class="ucmr-grid-2"><input type="text" id="ucmr-job-link-title" class="ucmr-input-field" placeholder="Text"><input type="url" id="ucmr-job-link-url" class="ucmr-input-field" placeholder="URL"></div>
                        
                        <div class="ucmr-form-row" style="margin-top:15px;"><label class="ucmr-label">Custom Instructions</label><textarea id="ucmr-job-custom-prompt" class="ucmr-textarea-field" rows="2" placeholder="Extra guidance..."></textarea></div>
                        
                        <div class="ucmr-form-row" style="margin-top:10px;">
                             <label class="ucmr-label"><input type="checkbox" id="ucmr-job-podcast" checked> Generate Podcast Audio</label>
                        </div>
                        
                        <div class="ucmr-form-row" style="margin-top:15px;">
                             <label class="ucmr-label">Auto-Repurpose to:</label>
                             <div style="display:flex; gap:10px; flex-wrap:wrap;">
                                 <label><input type="checkbox" id="ucmr-job-social-x" checked> X</label>
                                 <label><input type="checkbox" id="ucmr-job-social-fb" checked> FB</label>
                                 <label><input type="checkbox" id="ucmr-job-social-li" checked> LinkedIn</label>
                                 <label><input type="checkbox" id="ucmr-job-social-ig"> IG</label>
                                 <label><input type="checkbox" id="ucmr-job-social-tt"> TikTok</label>
                                 <label><input type="checkbox" id="ucmr-job-social-yt"> YouTube</label>
                             </div>
                        </div>

                        <button type="button" id="ucmr-job-create-btn" class="ucmr-btn-primary" style="margin-top:15px;">Schedule Job</button>
                    </div>

                    <div class="ucmr-card">
                        <h2>Active Jobs</h2>
                        <table class="wp-list-table widefat fixed striped">
                            <thead><tr><th>Name</th><th>Source</th><th>Next Run</th><th>Action</th></tr></thead>
                            <tbody id="ucmr-job-list">
                                <?php if(!empty($jobs)): foreach($jobs as $j): ?>
                                    <tr>
                                        <td><?php echo esc_html($j->job_name); ?></td>
                                        <td><?php echo esc_html($j->topic_prompt); ?></td>
                                        <td><?php echo esc_html($j->next_run); ?></td>
                                        <td><button type="button" class="button ucmr-job-delete" data-id="<?php echo $j->id; ?>">Delete</button></td>
                                    </tr>
                                <?php endforeach; else: echo '<tr><td colspan="4">No jobs scheduled.</td></tr>'; endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php if(!$is_premium): ?>
                    <div style="margin-top:20px; padding: 20px; background: #ffebeb; border: 1px solid #d63638; color: #d63638; font-weight: bold; text-align: center;">
                        Premium Feature Locked. Please activate your license to use the Scheduler.
                    </div>
                <?php endif; ?>
            </div>

            <!-- TAB 3: SOCIAL CONNECTIONS -->
            <div id="connections" class="ucmr-tab-content">
                <h2>Social Media Connections</h2>
                <p>Connect your accounts to enable auto-repurposing.</p>
                <div class="ucmr-admin-grid">
                    <div class="ucmr-card">
                        <h3>X (Twitter)</h3>
                        <a href="https://developer.x.com/en/portal/dashboard" target="_blank" class="ucmr-btn-secondary" style="font-size:11px; float:right;">Get Credentials</a>
                        <div class="ucmr-form-row"><label>Client ID</label><input type="password" name="ucmr_options[social_x_key]" value="<?php echo esc_attr($options['social_x_key']??''); ?>" class="ucmr-input-field"></div>
                        <div class="ucmr-form-row"><label>Client Secret</label><input type="password" name="ucmr_options[social_x_secret]" value="<?php echo esc_attr($options['social_x_secret']??''); ?>" class="ucmr-input-field"></div>
                    </div>
                    <div class="ucmr-card">
                        <h3>Facebook / Instagram</h3>
                        <a href="https://developers.facebook.com/apps/" target="_blank" class="ucmr-btn-secondary" style="font-size:11px; float:right;">Get Credentials</a>
                        <div class="ucmr-form-row"><label>App ID</label><input type="text" name="ucmr_options[social_fb_app_id]" value="<?php echo esc_attr($options['social_fb_app_id']??''); ?>" class="ucmr-input-field"></div>
                        <div class="ucmr-form-row"><label>Access Token</label><input type="password" name="ucmr_options[social_fb_token]" value="<?php echo esc_attr($options['social_fb_token']??''); ?>" class="ucmr-input-field"></div>
                    </div>
                    <div class="ucmr-card">
                        <h3>LinkedIn</h3>
                        <a href="https://www.linkedin.com/developers/apps" target="_blank" class="ucmr-btn-secondary" style="font-size:11px; float:right;">Get Credentials</a>
                        <div class="ucmr-form-row"><label>Client ID</label><input type="password" name="ucmr_options[social_li_key]" value="<?php echo esc_attr($options['social_li_key']??''); ?>" class="ucmr-input-field"></div>
                        <div class="ucmr-form-row"><label>Client Secret</label><input type="password" name="ucmr_options[social_li_secret]" value="<?php echo esc_attr($options['social_li_secret']??''); ?>" class="ucmr-input-field"></div>
                    </div>
                    <div class="ucmr-card">
                        <h3>TikTok</h3>
                        <a href="https://developers.tiktok.com/" target="_blank" class="ucmr-btn-secondary" style="font-size:11px; float:right;">Get Credentials</a>
                        <div class="ucmr-form-row"><label>Client Key</label><input type="password" name="ucmr_options[social_tt_key]" value="<?php echo esc_attr($options['social_tt_key']??''); ?>" class="ucmr-input-field"></div>
                        <div class="ucmr-form-row"><label>Client Secret</label><input type="password" name="ucmr_options[social_tt_secret]" value="<?php echo esc_attr($options['social_tt_secret']??''); ?>" class="ucmr-input-field"></div>
                    </div>
                    <div class="ucmr-card">
                        <h3>YouTube</h3>
                        <a href="https://console.cloud.google.com/" target="_blank" class="ucmr-btn-secondary" style="font-size:11px; float:right;">Get Credentials</a>
                        <div class="ucmr-form-row"><label>Client ID</label><input type="password" name="ucmr_options[social_yt_key]" value="<?php echo esc_attr($options['social_yt_key']??''); ?>" class="ucmr-input-field"></div>
                        <div class="ucmr-form-row"><label>Client Secret</label><input type="password" name="ucmr_options[social_yt_secret]" value="<?php echo esc_attr($options['social_yt_secret']??''); ?>" class="ucmr-input-field"></div>
                    </div>
                </div>
                <?php submit_button(); ?>
            </div>

            <!-- TAB 4: AI CONFIG -->
            <div id="ai-config" class="ucmr-tab-content">
                <h2>AI Provider Configuration</h2>
                <div class="ucmr-form-row">
                    <label class="ucmr-label">Default AI</label>
                    <select name="ucmr_options[ai_provider]" id="ucmr-ai-provider-select" class="ucmr-input-field">
                        <option value="gemini" <?php selected($options['ai_provider']??'','gemini'); ?>>Google Gemini</option>
                        <option value="chatgpt" <?php selected($options['ai_provider']??'','chatgpt'); ?>>OpenAI</option>
                        <option value="claude" <?php selected($options['ai_provider']??'','claude'); ?>>Claude</option>
                        <option value="grok" <?php selected($options['ai_provider']??'','grok'); ?>>Grok</option>
                        <option value="deepseek" <?php selected($options['ai_provider']??'','deepseek'); ?>>DeepSeek</option>
                    </select>
                </div>
                <div class="ucmr-form-row">
                    <label>Select Model</label>
                    <select name="ucmr_options[ai_model]" id="ucmr-ai-model-select" class="ucmr-input-field">
                        <option value="<?php echo esc_attr($options['ai_model']??''); ?>"><?php echo esc_html($options['ai_model']??'Default'); ?></option>
                    </select>
                </div>
                <div class="ucmr-card">
                    <h3>API Keys</h3>
                    <label>Gemini (<a href="https://aistudio.google.com/" target="_blank">Get Key</a>)</label>
                    <input type="password" name="ucmr_options[gemini_api_key]" value="<?php echo esc_attr($options['gemini_api_key']??''); ?>" class="ucmr-input-field">
                    <label>OpenAI (<a href="https://platform.openai.com/" target="_blank">Get Key</a>)</label>
                    <input type="password" name="ucmr_options[chatgpt_api_key]" value="<?php echo esc_attr($options['chatgpt_api_key']??''); ?>" class="ucmr-input-field">
                    <label>Claude (<a href="https://console.anthropic.com/" target="_blank">Get Key</a>)</label>
                    <input type="password" name="ucmr_options[claude_api_key]" value="<?php echo esc_attr($options['claude_api_key']??''); ?>" class="ucmr-input-field">
                    <label>Grok</label><input type="password" name="ucmr_options[grok_api_key]" value="<?php echo esc_attr($options['grok_api_key']??''); ?>" class="ucmr-input-field">
                    <label>DeepSeek</label><input type="password" name="ucmr_options[deepseek_api_key]" value="<?php echo esc_attr($options['deepseek_api_key']??''); ?>" class="ucmr-input-field">
                </div>
                <?php submit_button(); ?>
            </div>

            <!-- TAB 5: GLOBAL SETTINGS -->
            <div id="global" class="ucmr-tab-content">
                <h2>Global Settings</h2>
                <div class="ucmr-card">
                    <h3>Search & Media Keys</h3>
                    <div class="ucmr-form-row"><label>Google Search API Key (<a href="https://developers.google.com/custom-search/v1/overview" target="_blank">Get Key</a>)</label><input type="password" name="ucmr_options[search_google_api_key]" value="<?php echo esc_attr($options['search_google_api_key']??''); ?>" class="ucmr-input-field"></div>
                    <div class="ucmr-form-row"><label>Google Search Engine ID (CX) (<a href="https://programmablesearchengine.google.com/about/" target="_blank">Get CX</a>)</label><input type="text" name="ucmr_options[search_google_cx]" value="<?php echo esc_attr($options['search_google_cx']??''); ?>" class="ucmr-input-field"></div>
                    <hr>
                    <div class="ucmr-form-row"><label>Pixabay Key (<a href="https://pixabay.com/api/docs/" target="_blank">Get Key</a>)</label><input type="password" name="ucmr_options[media_pixabay_key]" value="<?php echo esc_attr($options['media_pixabay_key']??''); ?>" class="ucmr-input-field"></div>
                    <div class="ucmr-form-row"><label>Pexels Key (<a href="https://www.pexels.com/api/" target="_blank">Get Key</a>)</label><input type="password" name="ucmr_options[media_pexels_key]" value="<?php echo esc_attr($options['media_pexels_key']??''); ?>" class="ucmr-input-field"></div>
                    <div class="ucmr-form-row"><label>Unsplash Key (<a href="https://unsplash.com/developers" target="_blank">Get Key</a>)</label><input type="password" name="ucmr_options[media_unsplash_key]" value="<?php echo esc_attr($options['media_unsplash_key']??''); ?>" class="ucmr-input-field"></div>
                    <div class="ucmr-form-row"><label>YouTube Data API v3 (<a href="https://console.cloud.google.com/" target="_blank">Get Key</a>)</label><input type="password" name="ucmr_options[media_youtube_key]" value="<?php echo esc_attr($options['media_youtube_key']??''); ?>" class="ucmr-input-field"></div>
                    <div class="ucmr-form-row"><label>ElevenLabs Key (<a href="https://elevenlabs.io/" target="_blank">Get Key</a>)</label><input type="password" name="ucmr_options[elevenlabs_api_key]" value="<?php echo esc_attr($options['elevenlabs_api_key']??''); ?>" class="ucmr-input-field"></div>
                </div>
                <?php submit_button(); ?>
            </div>

            <!-- TAB 6: AD PLACEMENTS -->
            <div id="ads" class="ucmr-tab-content">
                 <div class="ucmr-card" style="background:#e8f4fd;"><h3>Ad Rotation</h3><p>Add up to 5 ads. System rotates based on frequency.</p></div>
                 <div id="ad-top">
                    <?php for($i=1;$i<=5;$i++): ?>
                        <div class="ucmr-ad-slot" style="<?php echo !$is_premium?'opacity:0.6':''?>">
                            <label>Slot <?php echo $i; ?> Freq: <input type="number" name="ucmr_options[ads_top_<?php echo $i; ?>_freq]" value="<?php echo esc_attr($options["ads_top_{$i}_freq"]??10); ?>" style="width:50px;" <?php echo !$is_premium?'disabled':''?>></label>
                            <label><input type="checkbox" name="ucmr_options[ads_top_<?php echo $i; ?>_enable]" value="1" <?php checked($options["ads_top_{$i}_enable"]??'0','1'); ?> <?php echo !$is_premium?'disabled':''?>> Enable</label>
                            <textarea name="ucmr_options[ads_top_<?php echo $i; ?>_code]" class="ucmr-textarea-field" rows="2" <?php echo !$is_premium?'disabled':''?>><?php echo esc_textarea($options["ads_top_{$i}_code"]??''); ?></textarea>
                        </div>
                    <?php endfor; ?>
                 </div>
                 <?php if($is_premium) submit_button(); ?>
            </div>

            <!-- TAB 7: LICENSE -->
            <div id="license" class="ucmr-tab-content">
                <h2>License Activation</h2>
                <?php if ( $is_premium ) : ?>
                    <div class="ucmr-response-box ucmr-response-success">✅ License Active! Premium features unlocked.</div>
                <?php else : ?>
                    <div class="ucmr-response-box ucmr-response-error">
                        ⚠️ License Inactive. 
                        <br><small>Debug Info: <?php echo esc_html( get_option('ucmr_license_debug_msg', 'No debug info.') ); ?></small>
                    </div>
                <?php endif; ?>
                <div class="ucmr-card">
                    <label>License Key</label>
                    <input type="password" name="ucmr_options[license_key]" value="<?php echo esc_attr($options['license_key']??''); ?>" class="ucmr-input-field">
                </div>
                <?php submit_button('Save & Activate'); ?>
            </div>

        </div>
    </form>
</div>