jQuery( document ).ready( function ( $ ) {

    // Pro License Activation
    $( '#uwlm-pro-license-btn' ).on( 'click', function ( e ) {
        e.preventDefault();
        var $button = $( this );
        var $keyField = $( '#uwlm_premium_license_key' );
        var $status = $( '#uwlm-pro-status' );
        var $message = $( '#uwlm-pro-message' );
        var action = $button.data( 'action' );

        $button.prop( 'disabled', true );
        $message.html( '' ).removeClass( 'notice-success notice-error' );
        
        var spinner = $( '<span class="uwlm-pro-spinner"></span>' );
        $button.after( spinner.show() );

        var ajaxAction = ( action === 'activate' ) ? 'uwlm_activate_pro_license' : 'uwlm_deactivate_pro_license';
        var data = {
            action: ajaxAction,
            nonce: uwlm_admin.nonce,
            license_key: $keyField.val(),
        };

        $.post( uwlm_admin.ajax_url, data, function ( response ) {
            spinner.remove();
            $button.prop( 'disabled', false );

            if ( response.success ) {
                $message.html( '<p>' + response.data.message + '</p>' ).addClass( 'notice-success' );
                if ( action === 'activate' ) {
                    $status.text( 'ACTIVE' ).removeClass( 'uwlm-status-inactive' ).addClass( 'uwlm-status-active' );
                    $button.text( uwlm_admin.deactivating_text ).data( 'action', 'deactivate' );
                    $keyField.prop( 'readonly', true );
                } else {
                    $status.text( 'INACTIVE' ).removeClass( 'uwlm-status-active' ).addClass( 'uwlm-status-inactive' );
                    $button.text( uwlm_admin.activating_text ).data( 'action', 'activate' );
                    $keyField.prop( 'readonly', false );
                }
            } else {
                $message.html( '<p>' + response.data.message + '</p>' ).addClass( 'notice-error' );
            }
        } ).fail( function () {
            spinner.remove();
            $button.prop( 'disabled', false );
            $message.html( '<p>' + uwlm_admin.error_text + '</p>' ).addClass( 'notice-error' );
        } );
    } );
    
    // Generate Key Button on "Add New" page
    $( '#uwlm-generate-key-btn' ).on( 'click', function(e) {
        e.preventDefault();
        var $button = $(this);
        var $keyField = $('#license_key');
        
        $button.prop('disabled', true);
        
        $.post( uwlm_admin.ajax_url, { action: 'uwlm_generate_key_string', nonce: uwlm_admin.nonce }, function( response ) {
            if( response.success ) {
                $keyField.val( response.data.key );
            }
            $button.prop('disabled', false);
        });
    });

    // Toggle activation details in list table
    $( '.uwlm-view-activations' ).on( 'click', function(e) {
        e.preventDefault();
        var id = $(this).data('id');
        $( '#uwlm-activations-for-' + id ).toggle();
    });

} );