Ultimate WooCommerce Licenses Manager - API Documentation

This API allows you to programmatically activate, deactivate, check, and get version information for software licenses managed by the plugin.

Authentication

All API requests must be authenticated using API keys generated in the plugin's "Settings" page.

Two headers are required:

X-Api-Key: Your public API key. This is required for all requests.

X-Api-Secret: Your private API secret. This is required for sensitive requests (/activate, /deactivate).

Base URL: https://your-website.com/wp-json/uwlm/v1/

Endpoints

1. Activate License

Activates a license key for a specific instance. Requires both Public and Secret API keys.

Endpoint: POST /activate

Auth: X-Api-Key and X-Api-Secret headers required.

Request Body (JSON)

{
  "license_key": "XXXXX-XXXXX-XXXXX-XXXXX",
  "product_id": "123",
  "instance_url": "[https://client-site.com](https://client-site.com)"
}


license_key (string, required): The plaintext license key.

product_id (string, required): The WooCommerce product ID (or variation ID) this key is for.

instance_url (string, required): The URL of the site/instance being activated.

Response (Success 200)

{
  "activated": true,
  "expires": "2026-11-13T15:30:00",
  "message": "License activated."
}


expires will be null for lifetime licenses.

If the license was already active for this instance, a 200 success is still returned.

Response (Errors)

401 Forbidden (invalid_api_key / invalid_api_secret): API keys are missing or incorrect.

404 Not Found (invalid_key): The license key does not exist.

403 Forbidden (invalid_product): The key is not valid for this product_id.

403 Forbidden (key_not_active): The key's status is not 'active'.

403 Forbidden (key_expired): The license has expired.

403 Forbidden (max_activations): All available activations are in use.

2. Deactivate License

Deactivates a license from a specific instance. Requires both Public and Secret API keys.

Endpoint: POST /deactivate

Auth: X-Api-Key and X-Api-Secret headers required.

Request Body (JSON)

{
  "license_key": "XXXXX-XXXXX-XXXXX-XXXXX",
  "instance_url": "[https://client-site.com](https://client-site.com)"
}


Response (Success 200)

{
  "deactivated": true,
  "message": "License deactivated."
}


Response (Errors)

401 Forbidden: Invalid API keys.

404 Not Found (invalid_key): The license key does not exist.

404 Not Found (deactivation_failed): The instance URL was not found for this license, or it was already inactive.

3. Check License

Checks the validity, expiration, and activation status of a license. Only requires the Public API key.

Endpoint: POST /check

Auth: X-Api-Key header required.

Request Body (JSON)

{
  "license_key": "XXXXX-XXXXX-XXXXX-XXXXX",
  "product_id": "123"
}


Response (Success 200)

{
  "valid": true,
  "expires": "2026-11-13T15:30:00",
  "activations_left": 2,
  "activations_max": 3,
  "activations_current": 1
}


activations_left / activations_max will be "unlimited" for unlimited licenses.

Response (Errors)

401 Forbidden: Invalid API key.

404 Not Found (invalid_key): The license key does not exist.

403 Forbidden (invalid_product): The key is not valid for this product_id.

403 Forbidden (key_not_active): The key's status is not 'active'.

403 Forbidden (key_expired): The license has expired.

4. Get Version

Checks a license and returns the latest product version information. Only requires the Public API key.

Endpoint: GET /version

Auth: X-Api-Key header required.

Query Parameters

?license_key=XXXXX-XXXXX-XXXXX-XXXXX&product_id=123

Response (Success 200)

{
  "version": "1.2.1",
  "changelog": "<p>New feature: ...</p><ul><li>Fixed bug X.</li><li>Improved performance.</li></ul>",
  "download_url": "[https://your-website.com/wp-content/uploads/](https://your-website.com/wp-content/uploads/)..."
}


download_url will be the URL for the product's downloadable file, if one is configured.

Response (Errors)

401 Forbidden: Invalid API key.

404 Not Found (invalid_key): The license key does not exist.

403 Forbidden (invalid_product): The key is not valid for this product_id.

403 Forbidden (key_not_active): The key's status is not 'active'.

403 Forbidden (key_expired): The license has expired.