jQuery( document ).ready( function ( $ ) {
    // Toggle activation manager
    $( '.uwlm-manage-activations' ).on( 'click', function ( e ) {
        e.preventDefault();
        var keyId = $( this ).data( 'key-id' );
        var row = $( '#uwlm-activations-for-' + keyId );
        row.toggle();
    } );

    // Handle deactivation
    $( document ).on( 'click', '.uwlm-deactivate-instance', function ( e ) {
        e.preventDefault();

        if ( ! confirm( uwlm_public.confirm_deactivation ) ) {
            return;
        }

        var $button = $( this );
        var licenseId = $button.data( 'license-id' );
        var instanceUrl = $button.data( 'instance-url' );
        var $container = $button.closest( '.uwlm-activations-container' );
        var $spinner = $container.find( '.uwlm-spinner' );
        var $listItem = $button.closest( 'li' );

        $button.prop( 'disabled', true );
        $spinner.show();

        $.ajax( {
            url: uwlm_public.ajax_url,
            type: 'POST',
            data: {
                action: 'uwlm_deactivate_instance',
                nonce: uwlm_public.nonce,
                license_id: licenseId,
                instance_url: instanceUrl,
            },
            success: function ( response ) {
                $spinner.hide();
                if ( response.success ) {
                    // Remove the list item
                    $listItem.remove();
                    
                    // Update the activation count in the main table
                    var countCell = $( '.product-activations[data-key-id="' + licenseId + '"]' );
                    if ( countCell.length ) {
                        countCell.html( response.data.activations_html );
                    }
                    
                    // Check if no activations left
                    if( $container.find( '.uwlm-activations-list li' ).length === 0 ) {
                        $container.find( '.uwlm-activations-list' ).html( '<p>No active instances.</p>' );
                    }

                } else {
                    alert( response.data.message || uwlm_public.error_message );
                    $button.prop( 'disabled', false );
                }
            },
            error: function () {
                $spinner.hide();
                $button.prop( 'disabled', false );
                alert( uwlm_public.error_message );
            },
        } );
    } );
} );