<?php
/**
 * My Licenses Table Template
 *
 * @var array $keys Array of license key objects.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<table class="woocommerce-table woocommerce-table--order-details shop_table order_details uwlm-licenses-table">
	<thead>
		<tr>
			<th class="woocommerce-table__product-name product-name"><?php esc_html_e( 'Product', 'uwlm' ); ?></th>
			<th class="woocommerce-table__product-table product-key"><?php esc_html_e( 'License Key', 'uwlm' ); ?></th>
			<th class="woocommerce-table__product-table product-activations"><?php esc_html_e( 'Activations', 'uwlm' ); ?></th>
			<th class="woocommerce-table__product-table product-expires"><?php esc_html_e( 'Expires', 'uwlm' ); ?></th>
			<th class="woocommerce-table__product-table product-status"><?php esc_html_e( 'Status', 'uwlm' ); ?></th>
			<th class="woocommerce-table__product-table product-actions"><?php esc_html_e( 'Actions', 'uwlm' ); ?></th>
		</tr>
	</thead>
	<tbody>
		<?php foreach ( $keys as $key ) : ?>
			<?php
				$product_id    = $key->variation_id ? $key->variation_id : $key->product_id;
				$product       = wc_get_product( $product_id );
				$product_name  = $product ? $product->get_name() : get_the_title( $key->product_id );
				$plaintext_key = UWLM_Helpers::decrypt_key( $key->license_key, $key->iv );
                $max           = $key->max_activations > 0 ? $key->max_activations : '∞';
                $activations_html = sprintf( '<span id="activations-count-%d">%d / %s</span>', $key->id, $key->activations, $max );
			?>
			<tr class="woocommerce-table__line-item order_item">
				<td class="woocommerce-table__product-name product-name">
					<a href="<?php echo esc_url( get_permalink( $key->product_id ) ); ?>">
						<?php echo esc_html( $product_name ); ?>
					</a>
				</td>
				<td class="woocommerce-table__product-table product-key">
					<?php if ( $plaintext_key ) : ?>
						<code><?php echo esc_html( $plaintext_key ); ?></code>
					<?php else : ?>
						<em><?php esc_html_e( 'Key error', 'uwlm' ); ?></em>
					<?php endif; ?>
				</td>
				<td class="woocommerce-table__product-table product-activations" data-key-id="<?php echo $key->id; ?>">
					<?php echo $activations_html; // WPCS: XSS ok. ?>
				</td>
				<td class="woocommerce-table__product-table product-expires">
					<?php echo $key->expires_at ? esc_html( date_i18n( get_option( 'date_format' ), strtotime( $key->expires_at ) ) ) : esc_html__( 'Lifetime', 'uwlm' ); ?>
				</td>
				<td class="woocommerce-table__product-table product-status">
					<span class="uwlm-status uwlm-status-<?php echo esc_attr( $key->status ); ?>"><?php echo esc_html( ucfirst( $key->status ) ); ?></span>
				</td>
				<td class="woocommerce-table__product-table product-actions">
					<button class="button uwlm-manage-activations" data-key-id="<?php echo esc_attr( $key->id ); ?>"><?php esc_html_e( 'Manage', 'uwlm' ); ?></button>
				</td>
			</tr>
            <tr class="uwlm-activations-row" id="uwlm-activations-for-<?php echo esc_attr( $key->id ); ?>" style="display: none;">
                <td colspan="6">
                    <div class="uwlm-activations-container">
                        <h4><?php esc_html_e( 'Active Instances', 'uwlm' ); ?></h4>
                        <div class="uwlm-activations-list">
                            <?php $activations = UWLM_DB::get_activations( $key->id ); ?>
                            <?php if ( empty( $activations ) ) : ?>
                                <p><?php esc_html_e( 'No active instances.', 'uwlm' ); ?></p>
                            <?php else : ?>
                                <ul>
                                    <?php foreach ( $activations as $activation ) : ?>
                                        <li data-instance-url="<?php echo esc_attr( $activation->instance_url ); ?>">
                                            <span><?php echo esc_html( $activation->instance_url ); ?></span>
                                            <button class="uwlm-deactivate-instance" data-license-id="<?php echo esc_attr( $key->id ); ?>" data-instance-url="<?php echo esc_attr( $activation->instance_url ); ?>">
                                                <?php esc_html_e( 'Deactivate', 'uwlm' ); ?>
                                            </button>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                            <?php endif; ?>
                        </div>
                        <div class="uwlm-spinner" style="display:none;"></div>
                    </div>
                </td>
            </tr>
		<?php endforeach; ?>
	</tbody>
</table>