jQuery(document).ready(function($) {
    
    $('#uwsct-send-chat').off('click').on('click', function() {
        var input = $('#uwsct-chat-query');
        var msg = input.val();
        var chatBody = $('#uwsct-chat-messages');

        if(msg.trim() === '') return;

        // 1. Show User Message
        chatBody.append('<div class="chat-msg user">' + msg + '</div>');
        input.val('');
        chatBody.scrollTop(chatBody[0].scrollHeight);

        // 2. Show "Typing..." Indicator
        var loadingId = 'ai-loading-' + Date.now();
        chatBody.append('<div id="' + loadingId + '" class="chat-msg bot">Typing... <span class="spinner is-active" style="float:none; margin:0;"></span></div>');
        chatBody.scrollTop(chatBody[0].scrollHeight);

        // 3. Send to Server (Gemini)
        $.ajax({
            url: uwsct_vars.ajax_url,
            type: 'POST',
            data: {
                action: 'uwsct_ai_query',
                nonce: uwsct_vars.nonce,
                query: msg
            },
            success: function(response) {
                $('#' + loadingId).remove(); // Remove loader

                if (response.success) {
                    // Add Gemini's Response
                    // We replace newlines with <br> for formatting
                    var formattedAnswer = response.data.answer.replace(/\n/g, "<br>");
                    chatBody.append('<div class="chat-msg bot">' + formattedAnswer + '</div>');
                } else {
                    // Show Error
                    chatBody.append('<div class="chat-msg bot" style="color:red;">' + response.data.message + '</div>');
                }
                chatBody.scrollTop(chatBody[0].scrollHeight);
            },
            error: function() {
                $('#' + loadingId).remove();
                chatBody.append('<div class="chat-msg bot" style="color:red;">Network error. Please check your connection.</div>');
            }
        });
    });

    // Allow "Enter" key to send
    $('#uwsct-chat-query').on('keypress', function(e) {
        if(e.which == 13) {
            $('#uwsct-send-chat').click();
        }
    });
});