jQuery(document).ready(function($) {
    
    // License Activation AJAX
    $('#uwsct-license-form').on('submit', function(e) {
        e.preventDefault();
        
        var btn = $('#uwsct-activate-btn');
        var spinner = btn.next('.spinner');
        var messageBox = $('#uwsct-license-message');
        
        btn.prop('disabled', true);
        spinner.addClass('is-active');
        messageBox.html('').removeClass('notice notice-error notice-success');

        $.ajax({
            url: uwsct_vars.ajax_url,
            type: 'POST',
            data: {
                action: 'uwsct_activate_license',
                nonce: uwsct_vars.nonce,
                license_key: $('#uwsct_license_key').val()
            },
            success: function(response) {
                spinner.removeClass('is-active');
                btn.prop('disabled', false);

                if (response.success) {
                    messageBox.html('<p><strong>Success:</strong> ' + response.data.message + '</p>').addClass('notice notice-success');
                    // Reload page after 1.5s to unlock features
                    setTimeout(function() {
                        location.reload();
                    }, 1500);
                } else {
                    messageBox.html('<p><strong>Error:</strong> ' + response.data.message + '</p>').addClass('notice notice-error');
                }
            },
            error: function() {
                spinner.removeClass('is-active');
                btn.prop('disabled', false);
                messageBox.html('<p><strong>Error:</strong> Server communication failed. Please try again.</p>').addClass('notice notice-error');
            }
        });
    });

    // AI Assistant Toggle
    $('#uwsct-ai-trigger').on('click', function() {
        var chatWindow = $('#uwsct-chat-window');
        if (chatWindow.is(':visible')) {
            chatWindow.fadeOut(200);
        } else {
            chatWindow.css('display', 'flex').hide().fadeIn(200);
            $('#uwsct-chat-query').focus();
        }
    });

    // AI Assistant Send Logic (Placeholder for AI Module)
    $('#uwsct-send-chat').on('click', function() {
        var input = $('#uwsct-chat-query');
        var msg = input.val();
        if(msg.trim() === '') return;

        // Append User Message
        $('#uwsct-chat-messages').append('<div class="chat-msg user">' + msg + '</div>');
        input.val('');
        
        // Scroll to bottom
        var chatBody = $('#uwsct-chat-messages');
        chatBody.scrollTop(chatBody[0].scrollHeight);

        // Simulate Thinking... (Real logic comes in Module 4)
        setTimeout(function() {
            $('#uwsct-chat-messages').append('<div class="chat-msg bot">I am currently offline. Please configure the AI Logic module.</div>');
            chatBody.scrollTop(chatBody[0].scrollHeight);
        }, 600);
    });

    // Allow "Enter" key to send
    $('#uwsct-chat-query').on('keypress', function(e) {
        if(e.which == 13) {
            $('#uwsct-send-chat').click();
        }
    });
});