document.addEventListener('DOMContentLoaded', function() {
    var toggle = document.getElementById('uwsct-lang-toggle');
    var dropdown = document.getElementById('uwsct-lang-dropdown');
    var searchInput = document.getElementById('uwsct-lang-search');
    var listItems = document.querySelectorAll('#uwsct-lang-list li');
    var links = document.querySelectorAll('#uwsct-lang-list li a');

    if (toggle && dropdown) {
        // Toggle Dropdown
        toggle.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            
            if (dropdown.style.display === 'none' || dropdown.style.display === '') {
                dropdown.style.display = 'block';
                toggle.classList.add('active');
                if(searchInput) setTimeout(function(){ searchInput.focus(); }, 100);
            } else {
                dropdown.style.display = 'none';
                toggle.classList.remove('active');
            }
        });

        // Search Filtering
        if (searchInput) {
            searchInput.addEventListener('keyup', function() {
                var filter = this.value.toLowerCase();
                listItems.forEach(function(item) {
                    var text = item.getAttribute('data-name');
                    if (text && text.indexOf(filter) > -1) {
                        item.style.display = "";
                    } else {
                        item.style.display = "none";
                    }
                });
            });
            searchInput.addEventListener('click', function(e) { e.stopPropagation(); });
        }

        // Language Switching Logic (Cookie Method)
        links.forEach(function(link) {
            link.addEventListener('click', function(e) {
                var lang = this.getAttribute('data-lang');
                if (lang) {
                    e.preventDefault();
                    // 1. Set Google Translate Cookie
                    document.cookie = "googtrans=/auto/" + lang + "; path=/; domain=" + window.location.hostname;
                    document.cookie = "googtrans=/auto/" + lang + "; path=/";
                    
                    // 2. Reload to trigger translation
                    window.location.reload(); 
                }
            });
        });

        // Close when clicking outside
        document.addEventListener('click', function(e) {
            if (!toggle.contains(e.target) && !dropdown.contains(e.target)) {
                dropdown.style.display = 'none';
                toggle.classList.remove('active');
            }
        });
    }
});