<div class="uwsct-panel">
    <h3><span class="dashicons dashicons-performance"></span> Optimization & Caching Engine</h3>
    
    <?php if ( isset( $_GET['status'] ) && $_GET['status'] === 'saved' ) : ?>
        <div class="notice notice-success inline"><p>Settings saved successfully. Cache cleared.</p></div>
    <?php endif; ?>
    
    <?php if ( isset( $_GET['cf_status'] ) ) : ?>
        <?php if ( $_GET['cf_status'] === 'success' ) : ?>
            <div class="notice notice-success inline"><p>Cloudflare connection verified successfully!</p></div>
        <?php elseif ( $_GET['cf_status'] === 'error' ) : ?>
            <div class="notice notice-error inline"><p>Cloudflare connection failed. Check your API Key and Zone ID.</p></div>
        <?php endif; ?>
    <?php endif; ?>

    <!-- Detailed Guide Box -->
    <div class="uwsct-info-box" style="background: #f0f6fc; border-left: 4px solid #72aee6; padding: 20px; margin-bottom: 25px;">
        <h4 style="margin-top:0; color:#1d2327;">🚀 Performance Configuration Guide</h4>
        <p>For optimal speed, we recommend activating settings in this order:</p>
        <ol style="list-style: decimal; margin-left: 20px;">
            <li><strong>Safe Zone:</strong> Enable <em>Page Caching</em>, <em>GZIP</em>, and <em>Browser Caching</em>.</li>
            <li><strong>Cloudflare:</strong> Connect your Cloudflare account below to automatically clear remote cache when you update posts.</li>
            <li><strong>Exclusions:</strong> Ensure vital dynamic pages (Checkout, My Account) are checked in the "Cache Exclusions" section.</li>
        </ol>
    </div>

    <form method="post" action="<?php echo admin_url('admin-post.php'); ?>">
        <input type="hidden" name="action" value="uwsct_save_cache_settings">
        <?php wp_nonce_field('uwsct_cache_settings_nonce'); ?>
        
        <h4 class="section-title">Core Optimization</h4>
        <div class="uwsct-card-grid">
            <div class="uwsct-settings-card recommended">
                <div class="card-header">
                    <h4>Page Caching</h4>
                    <span class="badge-rec">Recommended</span>
                </div>
                <p class="description">Creates static HTML copies of your pages for instant loading.</p>
                <label class="switch">
                    <input type="checkbox" name="uwsct_enable_page_cache" <?php checked( get_option('uwsct_enable_page_cache'), 1 ); ?>>
                    <span class="slider round"></span>
                </label>
            </div>

            <div class="uwsct-settings-card recommended">
                <div class="card-header">
                    <h4>GZIP Compression</h4>
                    <span class="badge-rec">Recommended</span>
                </div>
                <p class="description">Compresses data sent to the browser.</p>
                <label class="switch">
                    <input type="checkbox" name="uwsct_enable_gzip" <?php checked( get_option('uwsct_enable_gzip'), 1 ); ?>>
                    <span class="slider round"></span>
                </label>
            </div>

            <div class="uwsct-settings-card recommended">
                <div class="card-header">
                    <h4>Browser Caching</h4>
                    <span class="badge-rec">Recommended</span>
                </div>
                <p class="description">Tells visitor browsers to save static files locally.</p>
                <label class="switch">
                    <input type="checkbox" name="uwsct_enable_browser_cache" <?php checked( get_option('uwsct_enable_browser_cache'), 1 ); ?>>
                    <span class="slider round"></span>
                </label>
            </div>

            <div class="uwsct-settings-card">
                <div class="card-header">
                    <h4>File Minification</h4>
                </div>
                <p class="description">Removes spaces/comments from code.</p>
                <p class="warning-text">⚠️ Check site after enabling.</p>
                <label class="switch">
                    <input type="checkbox" name="uwsct_enable_minification" <?php checked( get_option('uwsct_enable_minification'), 1 ); ?>>
                    <span class="slider round"></span>
                </label>
            </div>
        </div>

        <h4 class="section-title" style="margin-top: 40px;">CDN & Cloudflare Integration</h4>
        <div class="uwsct-card-grid" style="grid-template-columns: 1fr;">
            <div class="uwsct-settings-card">
                <div style="display:flex; align-items:center; gap:10px; margin-bottom:15px;">
                    <span class="dashicons dashicons-cloud" style="font-size:24px; color:#f38020;"></span>
                    <h4 style="margin:0;">Cloudflare Connection</h4>
                </div>
                <p class="description">Connect to Cloudflare to clear the remote cache automatically when you update content.</p>
                
                <div style="background:#f9f9f9; padding:15px; border:1px solid #eee; border-radius:5px;">
                    <label class="switch" style="margin-bottom:15px; display:block;">
                        <input type="checkbox" name="uwsct_enable_cloudflare" <?php checked( get_option('uwsct_enable_cloudflare'), 1 ); ?>>
                        <span class="slider round"></span> Enable Cloudflare Integration
                    </label>
                    
                    <div style="display:grid; grid-template-columns: 1fr 1fr; gap:20px;">
                        <div>
                            <label style="font-weight:600; font-size:12px; display:block; margin-bottom:5px;">Global API Key</label>
                            <input type="password" name="uwsct_cf_api_key" value="<?php echo esc_attr( get_option('uwsct_cf_api_key') ); ?>" style="width:100%;" placeholder="Global API Key">
                            <p class="description" style="font-size:11px; margin-top:3px;"><a href="https://dash.cloudflare.com/profile/api-tokens" target="_blank">Get API Key</a></p>
                        </div>
                        <div>
                            <label style="font-weight:600; font-size:12px; display:block; margin-bottom:5px;">Account Email</label>
                            <input type="text" name="uwsct_cf_email" value="<?php echo esc_attr( get_option('uwsct_cf_email') ); ?>" style="width:100%;" placeholder="email@example.com">
                        </div>
                    </div>
                    
                    <div style="margin-top:15px;">
                        <label style="font-weight:600; font-size:12px; display:block; margin-bottom:5px;">Zone ID</label>
                        <input type="text" name="uwsct_cf_zone_id" value="<?php echo esc_attr( get_option('uwsct_cf_zone_id') ); ?>" style="width:100%;" placeholder="Find this on your domain Overview page in Cloudflare">
                    </div>
                </div>
            </div>
        </div>

        <h4 class="section-title" style="margin-top: 40px;">Cache Exclusions</h4>
        <div class="uwsct-card-grid" style="grid-template-columns: 1fr;">
            <div class="uwsct-settings-card">
                <h4>Exclude Specific Pages</h4>
                <p class="description">Check the boxes for pages that should <strong>never</strong> be cached.</p>
                
                <div style="max-height: 200px; overflow-y: auto; border: 1px solid #ddd; padding: 10px; background: #fff; margin-bottom: 15px; border-radius: 4px;">
                    <?php
                    $pages = get_pages();
                    $excluded_ids = get_option('uwsct_cache_excluded_ids', []);
                    
                    if ( $pages ) {
                        foreach ( $pages as $page ) {
                            $checked = in_array( $page->ID, $excluded_ids ) ? 'checked' : '';
                            echo '<label style="display:block; margin-bottom: 5px;">';
                            echo '<input type="checkbox" name="uwsct_cache_excluded_ids[]" value="' . $page->ID . '" ' . $checked . '> ';
                            echo esc_html( $page->post_title ) . ' <span style="color:#999; font-size:11px;">(ID: ' . $page->ID . ')</span>';
                            echo '</label>';
                        }
                    } else {
                        echo '<p>No pages found.</p>';
                    }
                    ?>
                </div>

                <h4>Custom URL Exclusions</h4>
                <textarea name="uwsct_cache_excluded_paths" rows="3" style="width:100%; font-family:monospace; border:1px solid #ddd; padding:10px;" placeholder="/checkout/&#10;/my-account/"><?php echo esc_textarea( get_option('uwsct_cache_excluded_paths') ); ?></textarea>
            </div>
        </div>

        <h4 class="section-title" style="margin-top: 40px;">Advanced Optimization</h4>
        <div class="uwsct-card-grid">
            <div class="uwsct-settings-card">
                <h4>Mobile Caching</h4>
                <label class="switch">
                    <input type="checkbox" name="uwsct_cache_mobile" <?php checked( get_option('uwsct_cache_mobile'), 1 ); ?>>
                    <span class="slider round"></span>
                </label>
            </div>

            <div class="uwsct-settings-card warning">
                <h4>Cache for Logged-in Users</h4>
                <label class="switch">
                    <input type="checkbox" name="uwsct_cache_loggedin" <?php checked( get_option('uwsct_cache_loggedin'), 1 ); ?>>
                    <span class="slider round"></span>
                </label>
            </div>
            
            <div class="uwsct-settings-card">
                <h4>Cache Lifespan</h4>
                <div style="display: flex; align-items: center; gap: 10px; margin-top: 5px;">
                    <input type="number" name="uwsct_cache_lifespan" value="<?php echo esc_attr( get_option('uwsct_cache_lifespan', 10) ); ?>" min="1" max="168" style="width: 70px; padding: 5px;">
                    <span>Hours</span>
                </div>
            </div>
        </div>

        <hr style="margin: 20px 0; border: 0; border-top: 1px solid #eee;">
        <?php submit_button('Save Changes & Test Cloudflare', 'primary large'); ?>
    </form>
</div>

<style>
.uwsct-card-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin-top: 20px; }
@media (max-width: 782px) { .uwsct-card-grid { grid-template-columns: 1fr; } }
.uwsct-settings-card { background: #fff; padding: 20px; border: 1px solid #ccd0d4; border-radius: 6px; box-shadow: 0 2px 4px rgba(0,0,0,0.02); display: flex; flex-direction: column; justify-content: space-between; }
.uwsct-settings-card.recommended { border-top: 4px solid #00a32a; }
.uwsct-settings-card.warning { border-left: 4px solid #d63638; background: #fff5f5; }
.card-header { display: flex; justify-content: space-between; align-items: flex-start; margin-bottom: 10px; }
.uwsct-settings-card h4 { margin: 0; font-size: 1.1em; color: #1d2327; }
.badge-rec { background: #00a32a; color: #fff; padding: 3px 8px; border-radius: 4px; font-size: 10px; text-transform: uppercase; font-weight: bold; letter-spacing: 0.5px; }
.description { color: #50575e; margin-bottom: 5px; font-size: 13px; }
.warning-text { color: #d63638; font-weight: bold; font-size: 12px; }
.section-title { font-size: 1.3em; font-weight: 600; margin-top: 0; margin-bottom: 15px; padding-bottom: 10px; border-bottom: 1px solid #ddd; }
.switch { position: relative; display: inline-block; width: 44px; height: 22px; vertical-align: middle; margin-top: auto; }
.switch input { opacity: 0; width: 0; height: 0; }
.slider { position: absolute; cursor: pointer; top: 0; left: 0; right: 0; bottom: 0; background-color: #ccc; transition: .4s; border-radius: 34px; }
.slider:before { position: absolute; content: ""; height: 16px; width: 16px; left: 3px; bottom: 3px; background-color: white; transition: .4s; border-radius: 50%; }
input:checked + .slider { background-color: #2271b1; }
input:focus + .slider { box-shadow: 0 0 1px #2271b1; }
input:checked + .slider:before { transform: translateX(22px); }
</style>