<div class="uwsct-panel">
    <h3><span class="dashicons dashicons-dashboard"></span> System Overview</h3>
    <p>Welcome to the Ultimate WP Security, Cache & Translation dashboard. Use the sidebar to configure specific modules.</p>
    
    <?php if ( isset( $_GET['status'] ) && $_GET['status'] === 'saved' ) : ?>
        <div class="notice notice-success inline"><p>API Key saved successfully.</p></div>
    <?php endif; ?>
    
    <div style="display: grid; grid-template-columns: 1fr 1fr 1fr; gap: 20px; margin-bottom: 30px;">
        <div class="uwsct-info-box">
            <h4><span class="dashicons dashicons-performance"></span> Caching</h4>
            <p>Status: <?php echo get_option('uwsct_enable_page_cache') ? '<span style="color:green;font-weight:bold;">Active</span>' : '<span style="color:orange;">Inactive</span>'; ?></p>
        </div>
        <div class="uwsct-info-box">
            <h4><span class="dashicons dashicons-lock"></span> Security</h4>
            <p>Status: <?php echo get_option('uwsct_enable_firewall') ? '<span style="color:green;font-weight:bold;">Active</span>' : '<span style="color:orange;">Inactive</span>'; ?></p>
        </div>
        <div class="uwsct-info-box">
            <h4><span class="dashicons dashicons-translation"></span> Translation</h4>
            <p>Status: <?php echo get_option('uwsct_enable_switcher') ? '<span style="color:green;font-weight:bold;">Active</span>' : '<span style="color:orange;">Inactive</span>'; ?></p>
        </div>
    </div>

    <!-- AI Settings Section -->
    <div class="uwsct-license-box" style="background: #fff; border: 1px solid #e5e7eb; padding: 20px;">
        <h3><span class="dashicons dashicons-superhero"></span> AI Support Assistant</h3>
        <p>To enable the intelligent Chat Agent powered by Google Gemini, enter your API key below. <a href="https://aistudio.google.com/app/apikey" target="_blank">Get a free key here</a>.</p>
        
        <form method="post" action="<?php echo admin_url('admin-post.php'); ?>">
            <input type="hidden" name="action" value="uwsct_save_dashboard_settings">
            <?php wp_nonce_field('uwsct_dashboard_settings_nonce'); ?>
            
            <table class="form-table">
                <tr valign="top">
                    <th scope="row">Google Gemini API Key</th>
                    <td>
                        <input type="password" name="uwsct_gemini_api_key" value="<?php echo esc_attr( get_option('uwsct_gemini_api_key') ); ?>" style="width:100%; max-width:400px;" placeholder="AIzaSy..." />
                    </td>
                </tr>
            </table>
            
            <?php submit_button('Save API Key'); ?>
        </form>
    </div>
</div>