<?php
// Ensure variables are available
$is_active = isset($is_active) ? $is_active : false;
$days_left = isset($days_left) ? $days_left : 0;
?>
<div class="uwsct-header">
    <div class="uwsct-logo">
        <span class="dashicons dashicons-shield-alt"></span> 
        <h2>Ultimate WP Security, Cache & Translation</h2>
    </div>
    
    <div class="uwsct-status-bar">
        <?php if ( $is_active ) : ?>
            <?php if ( $this->licensing->is_license_valid() ) : ?>
                <span class="uwsct-badge success">
                    <span class="dashicons dashicons-yes" style="font-size:14px;height:14px;width:14px;"></span> 
                    Pro License Active
                </span>
            <?php else : ?>
                <span class="uwsct-badge warning">
                    <span class="dashicons dashicons-clock" style="font-size:14px;height:14px;width:14px;"></span> 
                    Trial Active: <?php echo intval($days_left); ?> Days Left
                </span>
                <a href="https://www.ultimatemultimediaconsult.com/product/ultimate-wordpress-security-cache-and-translation-plugin/" target="_blank" class="uwsct-btn-upgrade">Upgrade Now</a>
            <?php endif; ?>
        <?php else : ?>
            <span class="uwsct-badge danger">Trial Expired</span>
            <a href="<?php echo admin_url('admin.php?page=uwsct_dashboard&tab=license'); ?>" class="uwsct-btn-upgrade pulse">Activate License</a>
        <?php endif; ?>
    </div>
</div>