<div class="uwsct-panel">
    <h3><span class="dashicons dashicons-lock"></span> Security Fortress</h3>
    
    <?php if ( isset( $_GET['status'] ) && $_GET['status'] === 'saved' ) : ?>
        <div class="notice notice-success inline"><p>Security settings updated.</p></div>
    <?php endif; ?>

    <div class="uwsct-info-box" style="background: #f0f6fc; border-left: 4px solid #72aee6; padding: 20px; margin-bottom: 25px;">
        <h4 style="margin-top:0; color:#1d2327;">🛡️ Security Configuration Guide</h4>
        <p>Protect your site from hackers and bots with these layers:</p>
        <ul style="list-style: disc; margin-left: 20px;">
            <li><strong>Core Defense:</strong> Enable WAF and Login Guard immediately.</li>
            <li><strong>Hardening:</strong> Disable XML-RPC to stop automated attacks.</li>
            <li><strong>Access Control:</strong> Use 2FA and a Custom Login URL to hide your admin area.</li>
        </ul>
    </div>

    <form method="post" action="<?php echo admin_url('admin-post.php'); ?>">
        <input type="hidden" name="action" value="uwsct_save_security_settings">
        <?php wp_nonce_field('uwsct_security_settings_nonce'); ?>
        
        <h4 class="section-title">Active Protection</h4>
        <div class="uwsct-card-grid">
            
            <!-- Firewall Card -->
            <div class="uwsct-settings-card recommended">
                <div class="card-header">
                    <h4>Web App Firewall (WAF)</h4>
                    <span class="badge-rec">Recommended</span>
                </div>
                <p class="description"><strong>What it does:</strong> Analyzes incoming traffic and blocks malicious patterns (SQLi, XSS).</p>
                <label class="switch">
                    <input type="checkbox" name="uwsct_enable_firewall" <?php checked( get_option('uwsct_enable_firewall'), 1 ); ?>>
                    <span class="slider round"></span>
                </label>
            </div>

            <!-- Login Guard Card -->
            <div class="uwsct-settings-card recommended">
                <div class="card-header">
                    <h4>Login Brute Force Guard</h4>
                    <span class="badge-rec">Recommended</span>
                </div>
                <p class="description"><strong>What it does:</strong> Limits failed login attempts from a single IP address.</p>
                <label class="switch">
                    <input type="checkbox" name="uwsct_enable_login_guard" <?php checked( get_option('uwsct_enable_login_guard'), 1 ); ?>>
                    <span class="slider round"></span>
                </label>
            </div>

             <!-- File Change Detection -->
             <div class="uwsct-settings-card">
                <div class="card-header">
                    <h4>File Change Detection</h4>
                </div>
                <p class="description"><strong>What it does:</strong> Scans core files (wp-config.php, .htaccess) daily for unauthorized changes.</p>
                <p class="benefit"><strong>Benefit:</strong> Alerts you immediately if a hacker modifies critical files.</p>
                <label class="switch">
                    <input type="checkbox" name="uwsct_enable_file_change_detection" <?php checked( get_option('uwsct_enable_file_change_detection'), 1 ); ?>>
                    <span class="slider round"></span>
                </label>
            </div>

             <!-- Disable XML-RPC -->
             <div class="uwsct-settings-card recommended">
                <div class="card-header">
                    <h4>Disable XML-RPC</h4>
                     <span class="badge-rec">Recommended</span>
                </div>
                <p class="description"><strong>What it does:</strong> Blocks external apps from accessing your site via XML-RPC.</p>
                <p class="benefit"><strong>Benefit:</strong> Stops one of the most common brute force attack vectors.</p>
                <label class="switch">
                    <input type="checkbox" name="uwsct_disable_xmlrpc" <?php checked( get_option('uwsct_disable_xmlrpc'), 1 ); ?>>
                    <span class="slider round"></span>
                </label>
            </div>
            
             <!-- Two Factor Auth -->
             <div class="uwsct-settings-card">
                <div class="card-header">
                    <h4>Two-Factor Auth (2FA)</h4>
                </div>
                <p class="description"><strong>What it does:</strong> Sends a verification code to your email upon login.</p>
                <p class="benefit"><strong>Benefit:</strong> Even if a hacker steals your password, they cannot login.</p>
                <label class="switch">
                    <input type="checkbox" name="uwsct_enable_2fa" <?php checked( get_option('uwsct_enable_2fa'), 1 ); ?>>
                    <span class="slider round"></span>
                </label>
            </div>

             <!-- Change Login URL -->
             <div class="uwsct-settings-card">
                <div class="card-header">
                    <h4>Change Login URL</h4>
                </div>
                <p class="description"><strong>What it does:</strong> Hides the default <code>wp-login.php</code> page.</p>
                <div style="margin-top: 15px; background: #f9f9f9; padding: 10px; border: 1px solid #eee; border-radius: 4px;">
                    <label class="switch" style="margin-bottom: 10px; display:block;">
                        <input type="checkbox" name="uwsct_change_login_url" <?php checked( get_option('uwsct_change_login_url'), 1 ); ?>>
                        <span class="slider round"></span>
                    </label>
                    
                    <label for="uwsct_login_slug" style="font-size: 12px; font-weight: bold; display:block; margin-bottom: 5px;">New Login Slug:</label>
                    <div style="display: flex; align-items: center;">
                        <span style="background: #eee; padding: 6px 8px; border: 1px solid #ddd; border-right: 0; border-radius: 4px 0 0 4px; color: #666; font-size: 12px;"><?php echo home_url('/'); ?></span>
                        <input type="text" name="uwsct_login_slug" id="uwsct_login_slug" value="<?php echo esc_attr( get_option('uwsct_login_slug', 'my-login') ); ?>" style="width: 100%; padding: 6px; border: 1px solid #ddd; border-radius: 0 4px 4px 0;" placeholder="my-login">
                    </div>
                    <p style="font-size:11px; color:#666; margin-top:5px;">Don't forget this! Bookmark your new login URL.</p>
                </div>
            </div>

        </div>

        <h4 class="section-title" style="margin-top: 40px;">Advanced Access Control</h4>
        <div class="uwsct-card-grid" style="grid-template-columns: 1fr;">
             <div class="uwsct-settings-card">
                <h4>IP Whitelist</h4>
                <p class="description">Enter IP addresses (one per line) that should <strong>never</strong> be blocked by Login Guard or Firewall.</p>
                
                <textarea name="uwsct_whitelist_ips" rows="5" style="width:100%; font-family:monospace; border:1px solid #ddd; padding:10px;" placeholder="192.168.1.1"><?php 
                    $ips = get_option('uwsct_whitelist_ips', []);
                    echo esc_textarea( implode( "\n", $ips ) ); 
                ?></textarea>
                <p style="font-size:12px; color:#666; margin-top: 5px;">Your Current IP: <strong><?php echo $_SERVER['REMOTE_ADDR']; ?></strong></p>
            </div>
        </div>

        <hr style="margin: 20px 0; border: 0; border-top: 1px solid #eee;">
        <?php submit_button('Save Security Settings', 'primary large'); ?>
    </form>
</div>

<style>
/* Reusing the CSS from Cache Settings for consistency */
.uwsct-card-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin-top: 20px; }
@media (max-width: 782px) { .uwsct-card-grid { grid-template-columns: 1fr; } }

.uwsct-settings-card { 
    background: #fff; 
    padding: 20px; 
    border: 1px solid #ccd0d4; 
    border-radius: 6px; 
    box-shadow: 0 2px 4px rgba(0,0,0,0.02); 
    display: flex; flex-direction: column; justify-content: space-between;
}
.uwsct-settings-card.recommended { border-top: 4px solid #00a32a; }

.card-header { display: flex; justify-content: space-between; align-items: flex-start; margin-bottom: 10px; }
.uwsct-settings-card h4 { margin: 0; font-size: 1.1em; color: #1d2327; }

.badge-rec { background: #00a32a; color: #fff; padding: 3px 8px; border-radius: 4px; font-size: 10px; text-transform: uppercase; font-weight: bold; letter-spacing: 0.5px; }

.description { color: #50575e; margin-bottom: 5px; font-size: 13px; }
.benefit { color: #2271b1; font-size: 13px; margin-bottom: 15px; font-style: italic; }

.section-title { font-size: 1.3em; font-weight: 600; margin-top: 0; margin-bottom: 15px; padding-bottom: 10px; border-bottom: 1px solid #ddd; }

/* Switch Toggle Styles */
.switch { position: relative; display: inline-block; width: 44px; height: 22px; vertical-align: middle; margin-top: auto; }
.switch input { opacity: 0; width: 0; height: 0; }
.slider { position: absolute; cursor: pointer; top: 0; left: 0; right: 0; bottom: 0; background-color: #ccc; transition: .4s; border-radius: 34px; }
.slider:before { position: absolute; content: ""; height: 16px; width: 16px; left: 3px; bottom: 3px; background-color: white; transition: .4s; border-radius: 50%; }
input:checked + .slider { background-color: #2271b1; }
input:focus + .slider { box-shadow: 0 0 1px #2271b1; }
input:checked + .slider:before { transform: translateX(22px); }
</style>