<div class="uwsct-panel">
    <h3><span class="dashicons dashicons-translation"></span> Translation Manager</h3>

    <?php if ( isset( $_GET['status'] ) && $_GET['status'] === 'saved' ) : ?>
        <div class="notice notice-success inline"><p>Translation settings updated.</p></div>
    <?php endif; ?>

    <div class="uwsct-info-box" style="background: #f0f6fc; border-left: 4px solid #72aee6; padding: 20px; margin-bottom: 25px;">
        <h4 style="margin-top:0; color:#1d2327;">🌍 Global Reach Configuration</h4>
        <p>Make your site accessible to the world with two powerful methods:</p>
        <ul style="list-style: disc; margin-left: 20px;">
            <li><strong>Frontend Widget:</strong> A floating button that lets users switch languages instantly. Does not require an API key.</li>
            <li><strong>Neural Translation (API):</strong> Uses Google Cloud to automatically translate your content server-side. Requires a Google API Key.</li>
        </ul>
    </div>

    <form method="post" action="<?php echo admin_url('admin-post.php'); ?>">
        <input type="hidden" name="action" value="uwsct_save_translation_settings">
        <?php wp_nonce_field('uwsct_translation_settings_nonce'); ?>
        
        <h4 class="section-title">Frontend Widget</h4>
        <div class="uwsct-card-grid">
            <div class="uwsct-settings-card recommended">
                <div class="card-header">
                    <h4>Enable Language Switcher</h4>
                    <span class="badge-rec">Recommended</span>
                </div>
                <p class="description">Displays a floating "Translate" button on your website.</p>
                <label class="switch">
                    <input type="checkbox" name="uwsct_enable_switcher" <?php checked( get_option('uwsct_enable_switcher'), 1 ); ?>>
                    <span class="slider round"></span>
                </label>
            </div>

            <div class="uwsct-settings-card">
                <h4>Widget Position</h4>
                <p class="description">Where should the floating button appear?</p>
                <select name="uwsct_switcher_position" style="width: 100%; max-width: 200px; margin-top: 10px;">
                    <option value="bottom-right" <?php selected( get_option('uwsct_switcher_position'), 'bottom-right' ); ?>>Bottom Right</option>
                    <option value="bottom-left" <?php selected( get_option('uwsct_switcher_position'), 'bottom-left' ); ?>>Bottom Left</option>
                    <option value="top-right" <?php selected( get_option('uwsct_switcher_position'), 'top-right' ); ?>>Top Right</option>
                    <option value="top-left" <?php selected( get_option('uwsct_switcher_position'), 'top-left' ); ?>>Top Left</option>
                </select>
            </div>

            <div class="uwsct-settings-card">
                <h4>Display Style</h4>
                <p class="description">How should languages be displayed in the list?</p>
                <select name="uwsct_switcher_display" style="width: 100%; max-width: 200px; margin-top: 10px;">
                    <option value="both" <?php selected( get_option('uwsct_switcher_display'), 'both' ); ?>>Flags & Names</option>
                    <option value="flags" <?php selected( get_option('uwsct_switcher_display'), 'flags' ); ?>>Flags Only</option>
                    <option value="names" <?php selected( get_option('uwsct_switcher_display'), 'names' ); ?>>Names Only</option>
                </select>
            </div>
        </div>

        <h4 class="section-title" style="margin-top: 40px;">Automatic Neural Translation (Optional)</h4>
        <div class="uwsct-card-grid" style="grid-template-columns: 1fr;">
             <div class="uwsct-settings-card">
                <h4>Google Cloud Translation API</h4>
                <p class="description">Enter your Google API Key to enable automatic server-side translation of your posts and pages.</p>
                <div style="display: flex; align-items: center; gap: 10px; margin-top: 10px;">
                    <input type="password" name="uwsct_google_api_key" value="<?php echo esc_attr( get_option('uwsct_google_api_key') ); ?>" class="regular-text" style="flex:1;" placeholder="AIzaSy...">
                </div>
                <p style="font-size: 12px; color: #666; margin-top: 5px;">
                    Don't have a key? <a href="https://console.cloud.google.com/apis/library/translate.googleapis.com" target="_blank">Get one here</a>. 
                    (Leave blank if you only want the frontend widget.)
                </p>
            </div>
        </div>

        <hr style="margin: 20px 0; border: 0; border-top: 1px solid #eee;">
        <?php submit_button('Save Translation Settings', 'primary large'); ?>
    </form>
</div>

<style>
/* Reusing the CSS from Cache Settings for consistency */
.uwsct-card-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin-top: 20px; }
@media (max-width: 782px) { .uwsct-card-grid { grid-template-columns: 1fr; } }

.uwsct-settings-card { 
    background: #fff; 
    padding: 20px; 
    border: 1px solid #ccd0d4; 
    border-radius: 6px; 
    box-shadow: 0 2px 4px rgba(0,0,0,0.02); 
    display: flex; flex-direction: column; justify-content: space-between;
}
.uwsct-settings-card.recommended { border-top: 4px solid #00a32a; }

.card-header { display: flex; justify-content: space-between; align-items: flex-start; margin-bottom: 10px; }
.uwsct-settings-card h4 { margin: 0; font-size: 1.1em; color: #1d2327; }

.badge-rec { background: #00a32a; color: #fff; padding: 3px 8px; border-radius: 4px; font-size: 10px; text-transform: uppercase; font-weight: bold; letter-spacing: 0.5px; }

.description { color: #50575e; margin-bottom: 5px; font-size: 13px; }
.benefit { color: #2271b1; font-size: 13px; margin-bottom: 15px; font-style: italic; }

.section-title { font-size: 1.3em; font-weight: 600; margin-top: 0; margin-bottom: 15px; padding-bottom: 10px; border-bottom: 1px solid #ddd; }

/* Switch Toggle Styles */
.switch { position: relative; display: inline-block; width: 44px; height: 22px; vertical-align: middle; margin-top: auto; }
.switch input { opacity: 0; width: 0; height: 0; }
.slider { position: absolute; cursor: pointer; top: 0; left: 0; right: 0; bottom: 0; background-color: #ccc; transition: .4s; border-radius: 34px; }
.slider:before { position: absolute; content: ""; height: 16px; width: 16px; left: 3px; bottom: 3px; background-color: white; transition: .4s; border-radius: 50%; }
input:checked + .slider { background-color: #2271b1; }
input:focus + .slider { box-shadow: 0 0 1px #2271b1; }
input:checked + .slider:before { transform: translateX(22px); }
</style>