<?php
namespace UWSCT\Inc\Cache;

class CDN_Integrator {

    const CF_API_URL = 'https://api.cloudflare.com/client/v4';

    public function __construct() {
        // Hook to purge cache when posts are saved
        add_action( 'save_post', [ $this, 'purge_cache_on_update' ] );
    }

    /**
     * Verify Credentials by checking Zone details.
     */
    public function test_connection() {
        $email = get_option( 'uwsct_cf_email' );
        $key = get_option( 'uwsct_cf_api_key' );
        $zone = get_option( 'uwsct_cf_zone_id' );

        if ( empty($email) || empty($key) || empty($zone) ) return false;

        $response = wp_remote_get( self::CF_API_URL . '/zones/' . $zone, [
            'headers' => [
                'X-Auth-Email' => $email,
                'X-Auth-Key'   => $key,
                'Content-Type' => 'application/json'
            ],
            'timeout' => 10
        ]);

        if ( is_wp_error( $response ) ) return false;

        $body = json_decode( wp_remote_retrieve_body( $response ), true );
        
        return ( isset( $body['success'] ) && $body['success'] === true );
    }

    /**
     * Purge Everything.
     */
    public function purge_cache_on_update() {
        $email = get_option( 'uwsct_cf_email' );
        $key = get_option( 'uwsct_cf_api_key' );
        $zone = get_option( 'uwsct_cf_zone_id' );

        if ( empty($email) || empty($key) || empty($zone) ) return;

        wp_remote_post( self::CF_API_URL . '/zones/' . $zone . '/purge_cache', [
            'headers' => [
                'X-Auth-Email' => $email,
                'X-Auth-Key'   => $key,
                'Content-Type' => 'application/json'
            ],
            'body' => json_encode( [ 'purge_everything' => true ] ),
            'blocking' => false // Fire and forget, don't slow down save
        ]);
    }
}