<?php
namespace UWSCT\Inc\Cache;

class Minification {

	public function __construct() {
		// Hook into buffer to process HTML output
		add_action( 'template_redirect', [ $this, 'start_buffer' ], 999 );
	}

	public function start_buffer() {
		if ( is_user_logged_in() ) return;
		ob_start( [ $this, 'minify_html_output' ] );
	}

	/**
	 * Minify HTML, Inline CSS and JS logic.
	 */
	public function minify_html_output( $buffer ) {
		// Remove comments
		$buffer = preg_replace( '/<!--(?!\s*(?:\[if [^\]]+]|<!|>))(?:(?!-->).)*-->/s', '', $buffer );
		
		// Remove whitespace between tags
		$buffer = preg_replace( '/>\s+</', '><', $buffer );
		
		// Remove whitespace around generic tags
		$buffer = preg_replace( '/\s+(<\\/?(?!pre|textarea|script|style)[^>]+>)/', '$1', $buffer );
		
		return $buffer;
	}
}