<?php
/**
 * Fired during plugin activation
 *
 * @package    Ultimate_WP_SCT
 * @subpackage Ultimate_WP_SCT/inc/common
 */

namespace UWSCT\Inc\Common;

class Activator {

	/**
	 * Fired during plugin activation.
	 *
	 * This function sets up the trial fingerprint and schedules cron jobs.
	 */
	public static function activate() {
		// 1. Set Install Date if not exists (Trial Start)
		// We use add_option instead of update_option so it doesn't reset if they deactivate/reactivate
		if ( ! get_option( Licensing::OPTION_INSTALL_DATE ) ) {
			add_option( Licensing::OPTION_INSTALL_DATE, time() );
		}

		// 2. Generate Site Fingerprint if not exists
		if ( ! get_option( Licensing::OPTION_FINGERPRINT ) ) {
			// We need to include the Licensing class here to use static methods if not autoloaded yet
			if ( ! class_exists( 'UWSCT\Inc\Common\Licensing' ) ) {
				require_once plugin_dir_path( dirname( __FILE__ ) ) . 'common/class-licensing.php';
			}
			$fingerprint = Licensing::generate_fingerprint();
			add_option( Licensing::OPTION_FINGERPRINT, $fingerprint );
		}

		// 3. Schedule Daily License Check (Cron)
		if ( ! wp_next_scheduled( 'uwsct_daily_license_check' ) ) {
			wp_schedule_event( time(), 'daily', 'uwsct_daily_license_check' );
		}

		// 4. Trigger Remote Registration (Attempt to register this install with the licensing server)
		// We instantiate the class to call the non-static method
		$licensing = new Licensing();
		$licensing->register_site_remotely();
	}
}