<?php
/**
 * Fired during plugin deactivation
 *
 * @package    Ultimate_WP_SCT
 * @subpackage Ultimate_WP_SCT/inc/common
 */

namespace UWSCT\Inc\Common;

class Deactivator {

	/**
	 * Fired during plugin deactivation.
	 *
	 * This class handles clearing the cron events scheduled by the plugin.
	 * It does NOT remove data (that happens in uninstall.php).
	 */
	public static function deactivate() {
		$timestamp = wp_next_scheduled( 'uwsct_daily_license_check' );
		if ( $timestamp ) {
			wp_unschedule_event( $timestamp, 'uwsct_daily_license_check' );
		}
	}
}