<?php
namespace UWSCT\Inc\Security;

class Scanner {

    public function __construct() {
        // Run scan daily via WP Cron
        if ( ! wp_next_scheduled( 'uwsct_daily_file_scan' ) ) {
            wp_schedule_event( time(), 'daily', 'uwsct_daily_file_scan' );
        }
        add_action( 'uwsct_daily_file_scan', [ $this, 'scan_core_files' ] );
    }

    public function scan_core_files() {
        // We check critical files for unauthorized changes
        $files_to_check = [
            ABSPATH . 'wp-config.php',
            ABSPATH . '.htaccess',
            ABSPATH . 'wp-settings.php'
        ];

        $changes = [];
        $stored_hashes = get_option( 'uwsct_file_hashes', [] );

        foreach ( $files_to_check as $file ) {
            if ( file_exists( $file ) ) {
                $current_hash = md5_file( $file );
                
                // If hash exists and is different, it's a change
                if ( isset( $stored_hashes[ $file ] ) && $stored_hashes[ $file ] !== $current_hash ) {
                    $changes[] = $file;
                }
                
                // Update stored hash
                $stored_hashes[ $file ] = $current_hash;
            }
        }

        update_option( 'uwsct_file_hashes', $stored_hashes );

        if ( ! empty( $changes ) ) {
            // Send email alert
            $admin_email = get_option( 'admin_email' );
            $subject = '[Security Alert] Critical File Change Detected';
            $message = "The following files have been modified on your site:\n\n" . implode( "\n", $changes ) . "\n\nPlease investigate immediately.";
            wp_mail( $admin_email, $subject, $message );
        }
    }
}