<?php
namespace UWSCT\Inc\Security;

class Two_Factor {

    public function __construct() {
        add_action( 'wp_login', [ $this, 'check_2fa' ], 10, 2 );
        add_action( 'login_form_uwsct_2fa_verify', [ $this, 'render_2fa_form' ] );
        add_action( 'login_form_validate_2fa', [ $this, 'validate_2fa_code' ] );
    }

    public function check_2fa( $user_login, $user ) {
        // Skip if 2FA is not enabled for this user role (Currently only Admins for MVP)
        if ( ! in_array( 'administrator', (array) $user->roles ) ) {
            return;
        }

        // Generate Code
        $code = rand( 100000, 999999 );
        update_user_meta( $user->ID, 'uwsct_2fa_code', $code );
        
        // Send Email
        wp_mail( $user->user_email, 'Your Login Verification Code', 'Your code is: ' . $code );

        // Redirect to 2FA form with User ID
        $redirect_to = add_query_arg( [
            'action' => 'uwsct_2fa_verify',
            'user_id' => $user->ID
        ], wp_login_url() );
        
        wp_redirect( $redirect_to );
        exit;
    }

    public function render_2fa_form() {
        $user_id = isset( $_GET['user_id'] ) ? intval( $_GET['user_id'] ) : 0;
        if ( ! $user_id ) return;

        // Simple output for 2FA form
        // In a real plugin, you might want to style this to match WP login
        login_header( 'Verify Login', '', false );
        ?>
        <form name="2faform" id="2faform" action="<?php echo esc_url( site_url( 'wp-login.php?action=validate_2fa' ) ); ?>" method="post">
            <p class="message">Please enter the 6-digit code sent to your email address.</p>
            <p>
                <label for="2fa_code">Verification Code<br />
                <input type="text" name="2fa_code" id="2fa_code" class="input" value="" size="20" autocomplete="off" /></label>
            </p>
            <input type="hidden" name="user_id" value="<?php echo esc_attr( $user_id ); ?>" />
            <p class="submit">
                <input type="submit" name="wp-submit" id="wp-submit" class="button button-primary button-large" value="Verify" />
            </p>
        </form>
        <?php
        login_footer();
        exit;
    }

    public function validate_2fa_code() {
        $code = isset($_POST['2fa_code']) ? sanitize_text_field( $_POST['2fa_code'] ) : '';
        $user_id = isset($_POST['user_id']) ? intval( $_POST['user_id'] ) : 0;
        
        $saved_code = get_user_meta( $user_id, 'uwsct_2fa_code', true );

        if ( ! empty($code) && $code == $saved_code ) {
            // Clear code
            delete_user_meta( $user_id, 'uwsct_2fa_code' );
            // Log user in properly
            wp_set_auth_cookie( $user_id );
            wp_redirect( admin_url() );
            exit;
        } else {
            wp_die( 'Invalid Code. Please go back and try again.', 'Error', ['response' => 403] );
        }
    }
}