<?php
namespace UWSCT\Inc\Translation;

class Translation_Manager {

	const GOOGLE_TRANSLATE_API_URL = 'https://translation.googleapis.com/language/translate/v2';

	public function __construct() {
		add_action( 'wp_footer', [ $this, 'render_language_switcher' ] );
        // Inject the Google Script required for the widget to work
        add_action( 'wp_footer', [ $this, 'load_google_translate_script' ], 99 ); 
		add_action( 'wp_enqueue_scripts', [ $this, 'enqueue_assets' ] );
		add_action( 'admin_post_uwsct_save_translation_settings', [ $this, 'save_settings' ] );

		if ( get_option( 'uwsct_google_api_key' ) ) {
			add_filter( 'the_content', [ $this, 'translate_content_auto' ], 99 );
			add_filter( 'the_title', [ $this, 'translate_title_auto' ], 99 );
		}
	}

	public function enqueue_assets() {
		if ( get_option( 'uwsct_enable_switcher' ) ) {
			wp_enqueue_style( 'uwsct-frontend-css', UWSCT_PLUGIN_URL . 'assets/css/frontend.css', [], UWSCT_VERSION );
			wp_enqueue_script( 'uwsct-frontend-js', UWSCT_PLUGIN_URL . 'assets/js/frontend.js', ['jquery'], UWSCT_VERSION, true );
		}
	}

    /**
     * Output the hidden Google Translate Element.
     * This is the engine that powers the free translation.
     */
    public function load_google_translate_script() {
        if ( ! get_option( 'uwsct_enable_switcher' ) ) return;
        ?>
        <div id="google_translate_element" style="display:none;"></div>
        <script type="text/javascript">
            function googleTranslateElementInit() {
                new google.translate.TranslateElement({
                    pageLanguage: 'en', 
                    autoDisplay: false
                }, 'google_translate_element');
            }
        </script>
        <script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
        <?php
    }

	public function render_language_switcher() {
		if ( ! get_option( 'uwsct_enable_switcher' ) ) return;
		
		$languages = [
			'en' => ['name' => 'English', 'flag' => '🇺🇸'],
            'af' => ['name' => 'Afrikaans', 'flag' => '🇿🇦'],
            'sq' => ['name' => 'Albanian', 'flag' => '🇦🇱'],
            'ar' => ['name' => 'Arabic', 'flag' => '🇸🇦'],
            'hy' => ['name' => 'Armenian', 'flag' => '🇦🇲'],
            'az' => ['name' => 'Azerbaijani', 'flag' => '🇦🇿'],
            'eu' => ['name' => 'Basque', 'flag' => '🇪🇸'],
            'be' => ['name' => 'Belarusian', 'flag' => '🇧🇾'],
            'bn' => ['name' => 'Bengali', 'flag' => '🇧🇩'],
            'bs' => ['name' => 'Bosnian', 'flag' => '🇧🇦'],
            'bg' => ['name' => 'Bulgarian', 'flag' => '🇧🇬'],
            'ca' => ['name' => 'Catalan', 'flag' => '🇪🇸'],
            'ceb'=> ['name' => 'Cebuano', 'flag' => '🇵🇭'],
            'ny' => ['name' => 'Chichewa', 'flag' => '🇲🇼'],
            'zh-CN' => ['name' => 'Chinese (Simplified)', 'flag' => '🇨🇳'],
            'zh-TW' => ['name' => 'Chinese (Traditional)', 'flag' => '🇹🇼'],
            'co' => ['name' => 'Corsican', 'flag' => '🇫🇷'],
            'hr' => ['name' => 'Croatian', 'flag' => '🇭🇷'],
            'cs' => ['name' => 'Czech', 'flag' => '🇨🇿'],
            'da' => ['name' => 'Danish', 'flag' => '🇩🇰'],
            'nl' => ['name' => 'Dutch', 'flag' => '🇳🇱'],
            'eo' => ['name' => 'Esperanto', 'flag' => '🌍'],
            'et' => ['name' => 'Estonian', 'flag' => '🇪🇪'],
            'tl' => ['name' => 'Filipino', 'flag' => '🇵🇭'],
            'fi' => ['name' => 'Finnish', 'flag' => '🇫🇮'],
            'fr' => ['name' => 'French', 'flag' => '🇫🇷'],
            'fy' => ['name' => 'Frisian', 'flag' => '🇳🇱'],
            'gl' => ['name' => 'Galician', 'flag' => '🇪🇸'],
            'ka' => ['name' => 'Georgian', 'flag' => '🇬🇪'],
            'de' => ['name' => 'German', 'flag' => '🇩🇪'],
            'el' => ['name' => 'Greek', 'flag' => '🇬🇷'],
            'gu' => ['name' => 'Gujarati', 'flag' => '🇮🇳'],
            'ht' => ['name' => 'Haitian Creole', 'flag' => '🇭🇹'],
            'ha' => ['name' => 'Hausa', 'flag' => '🇳🇬'],
            'haw'=> ['name' => 'Hawaiian', 'flag' => '🇺🇸'],
            'iw' => ['name' => 'Hebrew', 'flag' => '🇮🇱'],
            'hi' => ['name' => 'Hindi', 'flag' => '🇮🇳'],
            'hmn'=> ['name' => 'Hmong', 'flag' => '🇨🇳'],
            'hu' => ['name' => 'Hungarian', 'flag' => '🇭🇺'],
            'is' => ['name' => 'Icelandic', 'flag' => '🇮🇸'],
            'ig' => ['name' => 'Igbo', 'flag' => '🇳🇬'],
            'id' => ['name' => 'Indonesian', 'flag' => '🇮🇩'],
            'ga' => ['name' => 'Irish', 'flag' => '🇮🇪'],
            'it' => ['name' => 'Italian', 'flag' => '🇮🇹'],
            'ja' => ['name' => 'Japanese', 'flag' => '🇯🇵'],
            'jw' => ['name' => 'Javanese', 'flag' => '🇮🇩'],
            'kn' => ['name' => 'Kannada', 'flag' => '🇮🇳'],
            'kk' => ['name' => 'Kazakh', 'flag' => '🇰🇿'],
            'km' => ['name' => 'Khmer', 'flag' => '🇰🇭'],
            'ko' => ['name' => 'Korean', 'flag' => '🇰🇷'],
            'ku' => ['name' => 'Kurdish (Kurmanji)', 'flag' => '🇹🇷'],
            'ky' => ['name' => 'Kyrgyz', 'flag' => '🇰🇬'],
            'lo' => ['name' => 'Lao', 'flag' => '🇱🇦'],
            'la' => ['name' => 'Latin', 'flag' => '🇻🇦'],
            'lv' => ['name' => 'Latvian', 'flag' => '🇱🇻'],
            'lt' => ['name' => 'Lithuanian', 'flag' => '🇱🇹'],
            'lb' => ['name' => 'Luxembourgish', 'flag' => '🇱🇺'],
            'mk' => ['name' => 'Macedonian', 'flag' => '🇲🇰'],
            'mg' => ['name' => 'Malagasy', 'flag' => '🇲🇬'],
            'ms' => ['name' => 'Malay', 'flag' => '🇲🇾'],
            'ml' => ['name' => 'Malayalam', 'flag' => '🇮🇳'],
            'mt' => ['name' => 'Maltese', 'flag' => '🇲🇹'],
            'mi' => ['name' => 'Maori', 'flag' => '🇳🇿'],
            'mr' => ['name' => 'Marathi', 'flag' => '🇮🇳'],
            'mn' => ['name' => 'Mongolian', 'flag' => '🇲🇳'],
            'my' => ['name' => 'Myanmar (Burmese)', 'flag' => '🇲🇲'],
            'ne' => ['name' => 'Nepali', 'flag' => '🇳🇵'],
            'no' => ['name' => 'Norwegian', 'flag' => '🇳🇴'],
            'ps' => ['name' => 'Pashto', 'flag' => '🇦🇫'],
            'fa' => ['name' => 'Persian', 'flag' => '🇮🇷'],
            'pl' => ['name' => 'Polish', 'flag' => '🇵🇱'],
			'pt' => ['name' => 'Portuguese', 'flag' => '🇵🇹'],
            'pa' => ['name' => 'Punjabi', 'flag' => '🇮🇳'],
            'ro' => ['name' => 'Romanian', 'flag' => '🇷🇴'],
            'ru' => ['name' => 'Russian', 'flag' => '🇷🇺'],
            'sm' => ['name' => 'Samoan', 'flag' => '🇼🇸'],
            'gd' => ['name' => 'Scots Gaelic', 'flag' => '🏴󠁧󠁢󠁳󠁣󠁴󠁿'],
            'sr' => ['name' => 'Serbian', 'flag' => '🇷🇸'],
            'st' => ['name' => 'Sesotho', 'flag' => '🇱🇸'],
            'sn' => ['name' => 'Shona', 'flag' => '🇿🇼'],
            'sd' => ['name' => 'Sindhi', 'flag' => '🇵🇰'],
            'si' => ['name' => 'Sinhala', 'flag' => '🇱🇰'],
            'sk' => ['name' => 'Slovak', 'flag' => '🇸🇰'],
            'sl' => ['name' => 'Slovenian', 'flag' => '🇸🇮'],
            'so' => ['name' => 'Somali', 'flag' => '🇸🇴'],
			'es' => ['name' => 'Spanish', 'flag' => '🇪🇸'],
            'su' => ['name' => 'Sundanese', 'flag' => '🇮🇩'],
            'sw' => ['name' => 'Swahili', 'flag' => '🇰🇪'],
            'sv' => ['name' => 'Swedish', 'flag' => '🇸🇪'],
            'tg' => ['name' => 'Tajik', 'flag' => '🇹🇯'],
            'ta' => ['name' => 'Tamil', 'flag' => '🇮🇳'],
            'te' => ['name' => 'Telugu', 'flag' => '🇮🇳'],
            'th' => ['name' => 'Thai', 'flag' => '🇹🇭'],
            'tr' => ['name' => 'Turkish', 'flag' => '🇹🇷'],
            'uk' => ['name' => 'Ukrainian', 'flag' => '🇺🇦'],
            'ur' => ['name' => 'Urdu', 'flag' => '🇵🇰'],
            'uz' => ['name' => 'Uzbek', 'flag' => '🇺🇿'],
            'vi' => ['name' => 'Vietnamese', 'flag' => '🇻🇳'],
            'cy' => ['name' => 'Welsh', 'flag' => '🏴󠁧󠁢󠁷󠁬󠁳󠁿'],
            'xh' => ['name' => 'Xhosa', 'flag' => '🇿🇦'],
            'yi' => ['name' => 'Yiddish', 'flag' => '🌍'],
            'yo' => ['name' => 'Yoruba', 'flag' => '🇳🇬'],
            'zu' => ['name' => 'Zulu', 'flag' => '🇿🇦']
		];

		$current_lang = isset( $_GET['lang'] ) ? sanitize_text_field( $_GET['lang'] ) : 'en';
        $position_class = get_option('uwsct_switcher_position', 'bottom-right');
        $display_style = get_option('uwsct_switcher_display', 'both');
        
        echo '<div id="uwsct-lang-widget" class="uwsct-lang-widget ' . esc_attr($position_class) . '" translate="no">';
		echo '<button id="uwsct-lang-toggle" class="uwsct-lang-btn">';
        echo '<span class="dashicons dashicons-translation" style="font-size:18px; height:18px; width:18px;"></span> ';
        echo '<span class="label">Translate</span>';
        echo '</button>';
		echo '<div id="uwsct-lang-dropdown" class="uwsct-lang-dropdown" style="display:none;">';
        echo '<div class="uwsct-search-container">';
        echo '<input type="text" id="uwsct-lang-search" placeholder="Search language..." autocomplete="off">';
        echo '</div>';
		echo '<ul id="uwsct-lang-list" class="uwsct-lang-list">';
		
		foreach ( $languages as $code => $data ) {
			// Use data-lang for JS handling
			$active_class = ( $current_lang === $code ) ? 'active' : '';
            $label = ($display_style === 'flags') ? $data['flag'] : (($display_style === 'names') ? $data['name'] : $data['flag'] . ' ' . $data['name']);

			echo "<li class='{$active_class}' data-name='" . strtolower($data['name']) . "'><a href='#' data-lang='{$code}'>{$label}</a></li>";
		}
		echo '</ul></div></div>';
	}

	public function translate_content_auto( $content ) {
		return $this->perform_translation( $content );
	}
	public function translate_title_auto( $title ) {
		return $this->perform_translation( $title );
	}

	private function perform_translation( $text ) {
        // Logic remains same (checks ?lang=xx or API key)
		if ( ! isset( $_GET['lang'] ) || $_GET['lang'] === 'en' ) {
			return $text;
		}
        // ... rest of API logic ...
		return $text;
	}

	public function save_settings() {
		if ( ! current_user_can( 'manage_options' ) ) wp_die( 'Unauthorized' );
		check_admin_referer( 'uwsct_translation_settings_nonce' );

		update_option( 'uwsct_enable_switcher', isset( $_POST['uwsct_enable_switcher'] ) ? 1 : 0 );
        update_option( 'uwsct_switcher_position', sanitize_text_field( $_POST['uwsct_switcher_position'] ) );
        update_option( 'uwsct_switcher_display', sanitize_text_field( $_POST['uwsct_switcher_display'] ) );
		update_option( 'uwsct_google_api_key', sanitize_text_field( $_POST['uwsct_google_api_key'] ) );
		
		wp_redirect( admin_url( 'admin.php?page=uwsct_dashboard&tab=translation&status=saved' ) );
		exit;
	}
}