<?php
/**
 * Plugin Name:       Ultimate WordPress Security, Cache and Translation
 * Plugin URI:        https://www.ultimatemultimediaconsult.com/product/ultimate-wordpress-security-cache-and-translation-plugin/
 * Description:       An all-in-one industry-leading solution for high-performance caching, fortress-level security, and seamless multi-language translation. Includes a 30-day free Premium trial.
 * Version:           1.0.0
 * Author:            Ultimate Multimedia Consult
 * Author URI:        https://www.ultimatemultimediaconsult.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       ultimate-wp-sct
 * Domain Path:       /languages
 * Requires at least: 5.8
 * Requires PHP:      7.4
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

// Define Plugin Constants
if ( ! defined( 'UWSCT_VERSION' ) ) {
	define( 'UWSCT_VERSION', '1.0.0' );
}
if ( ! defined( 'UWSCT_PLUGIN_DIR' ) ) {
	define( 'UWSCT_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
}
if ( ! defined( 'UWSCT_PLUGIN_URL' ) ) {
	define( 'UWSCT_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
}
if ( ! defined( 'UWSCT_BASENAME' ) ) {
	define( 'UWSCT_BASENAME', plugin_basename( __FILE__ ) );
}
if ( ! defined( 'UWSCT_PRODUCT_ID' ) ) {
	define( 'UWSCT_PRODUCT_ID', '26220' );
}

/**
 * Main Plugin Class
 * Implements the Singleton pattern to ensure a single instance.
 */
class Ultimate_WP_SCT {

	private static $instance;
	public $licensing;
	public $admin;
	public $cache;
	public $security;
	public $translation;
	public $ai_agent;

	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	protected function __construct() {
		$this->load_dependencies();
		$this->define_admin_hooks();
		$this->define_public_hooks();
	}

	private function load_dependencies() {
		// 1. Common Utilities & Licensing
		if ( file_exists( UWSCT_PLUGIN_DIR . 'inc/common/class-licensing.php' ) ) {
			require_once UWSCT_PLUGIN_DIR . 'inc/common/class-licensing.php';
		}
		if ( file_exists( UWSCT_PLUGIN_DIR . 'inc/common/class-ai-agent.php' ) ) {
			require_once UWSCT_PLUGIN_DIR . 'inc/common/class-ai-agent.php';
		}

		// 2. Admin Dashboard
		if ( file_exists( UWSCT_PLUGIN_DIR . 'inc/admin/class-admin-manager.php' ) ) {
			require_once UWSCT_PLUGIN_DIR . 'inc/admin/class-admin-manager.php';
		}

		// 3. Core Modules - UPDATED PATHS
        // These now point to inc/cache, inc/security, inc/translation (NOT inc/admin/...)
		if ( file_exists( UWSCT_PLUGIN_DIR . 'inc/cache/class-cache-manager.php' ) ) {
			require_once UWSCT_PLUGIN_DIR . 'inc/cache/class-cache-manager.php';
		}
		if ( file_exists( UWSCT_PLUGIN_DIR . 'inc/security/class-security-manager.php' ) ) {
			require_once UWSCT_PLUGIN_DIR . 'inc/security/class-security-manager.php';
		}
		if ( file_exists( UWSCT_PLUGIN_DIR . 'inc/translation/class-translation-manager.php' ) ) {
			require_once UWSCT_PLUGIN_DIR . 'inc/translation/class-translation-manager.php';
		}

		// Initialize Managers
		if ( class_exists( 'UWSCT\Inc\Common\Licensing' ) ) {
			$this->licensing = new \UWSCT\Inc\Common\Licensing();
		} else {
            // Fallback dummy class
            $this->licensing = new class {
                public function is_license_active_or_trial() { return true; }
                public function get_trial_days_remaining() { return 30; }
                public function is_license_valid() { return false; }
            };
        }
		
        // Initialize Admin Manager
		if ( class_exists( 'UWSCT\Inc\Admin\Admin_Manager' ) ) {
			$this->admin = new \UWSCT\Inc\Admin\Admin_Manager( $this->licensing );
		}
		
		// Initialize Modules
		if ( $this->licensing->is_license_active_or_trial() ) {
			if ( class_exists( 'UWSCT\Inc\Cache\Cache_Manager' ) ) {
				$this->cache = new \UWSCT\Inc\Cache\Cache_Manager();
			}
			if ( class_exists( 'UWSCT\Inc\Security\Security_Manager' ) ) {
				$this->security = new \UWSCT\Inc\Security\Security_Manager();
			}
			if ( class_exists( 'UWSCT\Inc\Translation\Translation_Manager' ) ) {
				$this->translation = new \UWSCT\Inc\Translation\Translation_Manager();
			}
			if ( class_exists( 'UWSCT\Inc\Common\AI_Agent' ) ) {
				$this->ai_agent = new \UWSCT\Inc\Common\AI_Agent();
			}
		}
	}

	private function define_admin_hooks() {
		if ( isset( $this->admin ) ) {
			add_action( 'admin_enqueue_scripts', [ $this->admin, 'enqueue_styles' ] );
			add_action( 'admin_enqueue_scripts', [ $this->admin, 'enqueue_scripts' ] );
			add_action( 'admin_menu', [ $this->admin, 'add_plugin_admin_menu' ] );
		}
		
		if ( isset( $this->licensing ) && method_exists($this->licensing, 'check_remote_license_status') ) {
			add_action( 'uwsct_daily_license_check', [ $this->licensing, 'check_remote_license_status' ] );
		}
	}

	private function define_public_hooks() {
        // No init hook needed here as Cache Manager handles its own init
	}

	public function run() {
		// Core logic triggers
	}
}

/**
 * Activation Hook
 */
function activate_ultimate_wp_sct() {
    if ( file_exists( UWSCT_PLUGIN_DIR . 'inc/common/class-activator.php' ) ) {
	    require_once UWSCT_PLUGIN_DIR . 'inc/common/class-activator.php';
        if ( class_exists( 'UWSCT\Inc\Common\Activator' ) ) {
	        \UWSCT\Inc\Common\Activator::activate();
        }
    }
}

/**
 * Deactivation Hook
 */
function deactivate_ultimate_wp_sct() {
    if ( file_exists( UWSCT_PLUGIN_DIR . 'inc/common/class-deactivator.php' ) ) {
	    require_once UWSCT_PLUGIN_DIR . 'inc/common/class-deactivator.php';
        if ( class_exists( 'UWSCT\Inc\Common\Deactivator' ) ) {
	        \UWSCT\Inc\Common\Deactivator::deactivate();
        }
    }
}

register_activation_hook( __FILE__, 'activate_ultimate_wp_sct' );
register_deactivation_hook( __FILE__, 'deactivate_ultimate_wp_sct' );

/**
 * Begins execution of the plugin.
 */
function run_ultimate_wp_sct() {
	$plugin = Ultimate_WP_SCT::get_instance();
	$plugin->run();
}
run_ultimate_wp_sct();