<?php
/**
 * Fired when the plugin is uninstalled.
 *
 * @package    Ultimate_WP_SCT
 */

// If uninstall not called from WordPress, then exit.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

// Delete Plugin Options (Settings)
// We delete configuration settings but purposefully keep the install tracking data
// to prevent users from resetting the 30-day trial by deleting and reinstalling.

$options_to_delete = [
    'uwsct_license_key',
    'uwsct_license_status',
    'uwsct_enable_page_cache',
    'uwsct_enable_minification',
    'uwsct_enable_firewall',
    'uwsct_enable_login_guard',
    'uwsct_enable_switcher',
    // 'uwsct_install_date', // KEEP THIS: Prevents trial reset
    // 'uwsct_site_fingerprint' // KEEP THIS: Prevents trial reset
];

foreach ( $options_to_delete as $option ) {
    delete_option( $option );
}

// Clear any scheduled cron jobs
$timestamp = wp_next_scheduled( 'uwsct_daily_license_check' );
if ( $timestamp ) {
    wp_unschedule_event( $timestamp, 'uwsct_daily_license_check' );
}

// Drop any custom tables if added in future updates (None in v1.0.0)
/*
global $wpdb;
$table_name = $wpdb->prefix . 'uwsct_logs';
$wpdb->query( "DROP TABLE IF EXISTS $table_name" );
*/